/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging.masker;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import tech.petrepopescu.logging.masker.LogMasker;

public class CardNumberMasker
implements LogMasker {
    private static final List<Character> KNOWN_PAN_START_DIGITS = Arrays.asList(Character.valueOf('1'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'));
    protected int startKeep = 1;
    protected int endKeep = 6;
    protected boolean luhnCheck = false;
    protected char maskChar = (char)42;

    @Override
    public void initialize(String args) {
        if (StringUtils.isBlank((CharSequence)args)) {
            this.startKeep = 1;
            this.endKeep = 6;
        } else {
            String[] params = StringUtils.split((String)args, (char)'|');
            if (params.length != 2) {
                throw new ExceptionInInitializerError("Invalid parameters supplied for CardNumber masker: " + args);
            }
            this.startKeep = Integer.valueOf(params[0]);
            this.endKeep = Integer.valueOf(params[1]);
            if (this.startKeep < 1 || this.startKeep > 6) {
                throw new ExceptionInInitializerError("The number of unmasked digits at the start of the pan can't be more than 6 or less than 1");
            }
            if (this.endKeep < 1 || this.endKeep > 8) {
                throw new ExceptionInInitializerError("The number of unmasked digits at the end of the pan can't be more than 8 or less than 1");
            }
        }
    }

    @Override
    public int maskData(StringBuilder builder, int startPos, int buffLength) {
        int pos = startPos;
        Character checkChar = Character.valueOf(builder.charAt(pos));
        if (KNOWN_PAN_START_DIGITS.contains(checkChar)) {
            int panLength = 1;
            ++pos;
            while (pos < buffLength && Character.isDigit(builder.charAt(pos))) {
                ++panLength;
                ++pos;
            }
            if (this.validPan(builder, startPos, panLength, buffLength)) {
                builder.replace(startPos + this.startKeep, startPos + panLength - this.endKeep, StringUtils.repeat((char)this.maskChar, (int)(panLength - this.startKeep - this.endKeep)));
                return startPos + panLength;
            }
        }
        return startPos;
    }

    @Override
    public void setMaskChar(char maskChar) {
        this.maskChar = maskChar;
    }

    private boolean validPan(StringBuilder builder, int startPos, int panLength, int buffLength) {
        return panLength >= 8 && panLength <= 19 && (startPos + panLength == buffLength || LogMasker.isDelimiter(builder.charAt(startPos + panLength))) && this.luhnValid(builder, startPos, panLength);
    }

    private boolean luhnValid(StringBuilder builder, int startPos, int panLength) {
        if (this.luhnCheck) {
            int sum = 0;
            int pos = 0;
            for (int count = startPos; count < panLength + startPos; ++count) {
                if (pos % 2 == 0) {
                    int val = Character.getNumericValue(builder.charAt(count)) * 2;
                    sum += val;
                    if (val > 9) {
                        sum -= 9;
                    }
                } else {
                    sum += Character.getNumericValue(builder.charAt(count));
                }
                ++pos;
            }
            return sum % 10 == 0;
        }
        return true;
    }
}

