/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging.masker;

import org.apache.commons.lang3.StringUtils;
import tech.petrepopescu.logging.masker.LogMasker;

public class EmailMasker
implements LogMasker {
    protected char maskChar = (char)42;

    @Override
    public int maskData(StringBuilder builder, int startPos, int buffLength) {
        if (startPos == 0) {
            return startPos;
        }
        int pos = startPos;
        char character = builder.charAt(pos - 1);
        if ('@' == character) {
            int indexOfAt = pos - 1;
            int emailStartPos = this.indexOfStart(builder, --pos, indexOfAt);
            int indexOfEnd = this.indexOfEmailEnd(builder, indexOfAt + 1, emailStartPos, buffLength);
            int indexOfDot = this.indexOfDot(indexOfAt, indexOfEnd, builder);
            if (emailStartPos < indexOfAt && indexOfAt < indexOfDot && indexOfDot < indexOfEnd) {
                builder.replace(emailStartPos + 1, indexOfAt - 1, StringUtils.repeat((char)this.maskChar, (int)(indexOfAt - emailStartPos - 2))).replace(indexOfAt + 2, indexOfDot - 1, StringUtils.repeat((char)this.maskChar, (int)(indexOfDot - indexOfAt - 3)));
                return indexOfEnd;
            }
        }
        return startPos;
    }

    @Override
    public void setMaskChar(char maskChar) {
        this.maskChar = maskChar;
    }

    private int indexOfStart(StringBuilder unmasked, int pos, int indexOfAt) {
        while (pos >= 0 && !LogMasker.isDelimiter(unmasked.charAt(pos))) {
            if (--pos <= 0 || unmasked.charAt(pos) != '@') continue;
            return indexOfAt;
        }
        return pos + 1;
    }

    private int indexOfEmailEnd(StringBuilder unmasked, int startPost, int emailStart, int buffLength) {
        while (startPost < buffLength) {
            if (LogMasker.isDelimiter(unmasked.charAt(startPost))) {
                return startPost - 1;
            }
            if ('@' == unmasked.charAt(startPost)) {
                return emailStart;
            }
            ++startPost;
        }
        return startPost - 1;
    }

    private int indexOfDot(int startPos, int endPos, StringBuilder unmasked) {
        while (endPos > startPos && unmasked.charAt(endPos) != '.') {
            --endPos;
        }
        return endPos;
    }
}

