/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging.masker;

import tech.petrepopescu.logging.masker.LogMasker;

public class IPMasker
implements LogMasker {
    protected char maskChar = (char)42;

    @Override
    public int maskData(StringBuilder builder, int startPos, int buffLength) {
        int pos = startPos;
        Character character = Character.valueOf(builder.charAt(pos));
        if (Character.isDigit(character.charValue())) {
            int noDigits = 1;
            int noDots = 0;
            ++pos;
            while (pos < buffLength && !LogMasker.isDelimiter(builder.charAt(pos))) {
                character = Character.valueOf(builder.charAt(pos));
                ++pos;
                if (Character.isDigit(character.charValue())) {
                    if (++noDigits <= 3) continue;
                    return startPos;
                }
                if ('.' == character.charValue()) {
                    ++noDots;
                    noDigits = 0;
                    continue;
                }
                return startPos;
            }
            if (noDots == 3 || this.isDotAtEnd(noDots, builder, pos, buffLength)) {
                StringBuilder masked = new StringBuilder();
                int consecutiveDigits = 0;
                for (int charPos = startPos; charPos < pos; ++charPos) {
                    if ('.' == builder.charAt(charPos)) {
                        masked.append('.');
                        consecutiveDigits = 0;
                        continue;
                    }
                    if (consecutiveDigits == 0) {
                        masked.append(builder.charAt(charPos));
                        ++consecutiveDigits;
                        continue;
                    }
                    masked.append(this.maskChar);
                }
                builder.replace(startPos, pos, masked.toString());
                return pos;
            }
        }
        return startPos;
    }

    @Override
    public void setMaskChar(char maskChar) {
        this.maskChar = maskChar;
    }

    private boolean isDotAtEnd(int noDots, StringBuilder builder, int charPos, int buffLength) {
        return noDots == 4 && (charPos == buffLength || LogMasker.isDelimiter(builder.charAt(charPos)));
    }
}

