/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging.masker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface LogMasker {
    public static final List<Character> KNOWN_DELIMITERS = Collections.unmodifiableList(Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('=')));

    public static boolean isDelimiter(char character) {
        return Character.isWhitespace(character) || KNOWN_DELIMITERS.contains(Character.valueOf(character));
    }

    public static int indexOfNextDelimiter(StringBuilder builder, int startPos, int buffLength) {
        while (startPos < buffLength && !LogMasker.isDelimiter(builder.charAt(startPos))) {
            ++startPos;
        }
        return startPos;
    }

    default public void initialize(String params) {
    }

    public int maskData(StringBuilder var1, int var2, int var3);

    public void setMaskChar(char var1);
}

