/*
 * Decompiled with CFR 0.152.
 */
package tech.petrepopescu.logging.masker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import tech.petrepopescu.logging.masker.LogMasker;

public class PasswordMasker
implements LogMasker {
    private static final char DEFAULT_MASK_CHAR = '*';
    private static final List<String> KEYWORDS = Arrays.asList("password", "passphrase", "pwd", "pass");
    protected final List<String> keywords;
    private final List<String> separators = Arrays.asList(":", "=", "\": \"", "\":\"", ">");
    private String masked;

    public PasswordMasker() {
        this.keywords = new ArrayList<String>(KEYWORDS);
        this.masked = "******";
    }

    public PasswordMasker(String[] keywords) {
        this.keywords = Arrays.asList(keywords);
        this.masked = "******";
    }

    @Override
    public int maskData(StringBuilder builder, int startPos, int buffLength) {
        int charPos = startPos;
        if (charPos + 5 > buffLength) {
            return startPos;
        }
        Character character = Character.valueOf(builder.charAt(charPos));
        if (this.isPasswordStart(character, builder, charPos)) {
            int keywordStart = 0;
            int keywordLength = 0;
            String keywordUsed = null;
            for (String keyword : this.keywords) {
                keywordStart = StringUtils.indexOfIgnoreCase((CharSequence)builder, (CharSequence)keyword, (int)charPos);
                if (!this.keywordStartAtRightPosition(keywordStart, charPos)) continue;
                keywordLength = keyword.length();
                keywordUsed = keyword;
                break;
            }
            if (keywordStart != startPos && keywordStart != startPos + 1) {
                return startPos;
            }
            for (String separator : this.separators) {
                int endPos;
                int idxSeparator = StringUtils.indexOf((CharSequence)builder, (CharSequence)separator, (int)(keywordStart + keywordLength));
                if (idxSeparator != keywordStart + keywordLength || (endPos = this.detectEnd(builder, buffLength, charPos = this.passwordStartPosition(keywordStart, keywordLength, separator, builder), keywordUsed, keywordLength, separator)) <= charPos) continue;
                return this.mask(builder, '*', charPos, endPos);
            }
        }
        return startPos;
    }

    @Override
    public void setMaskChar(char maskChar) {
        this.masked = "" + maskChar + maskChar + maskChar + maskChar + maskChar + maskChar;
    }

    private int detectEnd(StringBuilder builder, int buffLength, int startPos, String keyword, int keywordLength, String separator) {
        if (separator.charAt(0) == '>') {
            return this.detectEndXml(builder, buffLength, startPos, keyword, keywordLength);
        }
        if (separator.contains("\"")) {
            return this.detectEndJson(builder, buffLength, startPos);
        }
        return this.detectEndNoXml(builder, buffLength, startPos);
    }

    private int detectEndNoXml(StringBuilder builder, int buffLength, int startPos) {
        while (startPos < buffLength && !LogMasker.isDelimiter(builder.charAt(startPos))) {
            ++startPos;
        }
        return startPos;
    }

    private int detectEndJson(StringBuilder builder, int buffLength, int startPos) {
        while (startPos < buffLength && !this.isEndOfJson(builder, startPos)) {
            ++startPos;
        }
        return startPos;
    }

    private boolean isEndOfJson(StringBuilder builder, int pos) {
        return builder.charAt(pos) == '\"' && builder.charAt(pos - 1) != '\\';
    }

    private int detectEndXml(StringBuilder builder, int buffLength, int startPos, String keyword, int keywordLength) {
        if (buffLength < startPos + keywordLength + 3) {
            return -1;
        }
        int passwordEnd = StringUtils.indexOfIgnoreCase((CharSequence)builder, (CharSequence)keyword, (int)startPos);
        if (passwordEnd > 0 && builder.charAt(passwordEnd - 1) == '/' && builder.charAt(passwordEnd - 2) == '<') {
            return passwordEnd - 2;
        }
        return -1;
    }

    private boolean isPasswordStart(Character character, StringBuilder builder, int pos) {
        return 'p' == character.charValue() || 'P' == character.charValue() || '<' == character.charValue() && 'p' == builder.charAt(pos + 1) || '<' == character.charValue() && 'P' == builder.charAt(pos + 1);
    }

    private boolean keywordStartAtRightPosition(int keywordStart, int pos) {
        return keywordStart >= 0 && (keywordStart == pos || keywordStart == pos + 1);
    }

    private int passwordStartPosition(int keywordStart, int keywordLength, String separator, StringBuilder builder) {
        int charPos = keywordStart + keywordLength + separator.length();
        if (Character.isWhitespace(builder.charAt(charPos))) {
            ++charPos;
        }
        return charPos;
    }

    private int mask(StringBuilder builder, char maskChar, int startPos, int endPos) {
        builder.replace(startPos, endPos, this.masked);
        return startPos + 6;
    }
}

