/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.TypeStore;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.request.http.SaveJobInfoRequest;
import tech.powerjob.common.request.http.SaveWorkflowNodeRequest;
import tech.powerjob.common.request.http.SaveWorkflowRequest;
import tech.powerjob.common.request.query.JobInfoQuery;
import tech.powerjob.common.response.InstanceInfoDTO;
import tech.powerjob.common.response.JobInfoDTO;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.response.WorkflowInfoDTO;
import tech.powerjob.common.response.WorkflowInstanceInfoDTO;
import tech.powerjob.common.response.WorkflowNodeInfoDTO;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.HttpUtils;

public class PowerJobClient {
    private static final Logger log = LoggerFactory.getLogger(PowerJobClient.class);
    private Long appId;
    private String currentAddress;
    private final List<String> allAddress;
    private static final String URL_PATTERN = "http://%s%s%s";

    public PowerJobClient(String domain, String appName, String password) {
        this(Lists.newArrayList((Object[])new String[]{domain}), appName, password);
    }

    public PowerJobClient(List<String> addressList, String appName, String password) {
        CommonUtils.requireNonNull(addressList, (String)"addressList can't be null!");
        CommonUtils.requireNonNull((Object)appName, (String)"appName can't be null");
        this.allAddress = addressList;
        for (String addr : addressList) {
            String url = PowerJobClient.getUrl("/assert", addr);
            try {
                String result = PowerJobClient.assertApp(appName, password, url);
                if (!StringUtils.isNotEmpty((CharSequence)result)) continue;
                ResultDTO resultDTO = (ResultDTO)JSON.parseObject((String)result, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
                if (!resultDTO.isSuccess()) {
                    throw new PowerJobException(resultDTO.getMessage());
                }
                this.appId = (Long)resultDTO.getData();
                this.currentAddress = addr;
                break;
            }
            catch (IOException iOException) {
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.currentAddress)) {
            throw new PowerJobException("no server available for PowerJobClient");
        }
        log.info("[PowerJobClient] {}'s PowerJobClient bootstrap successfully, using server: {}", (Object)appName, (Object)this.currentAddress);
    }

    private static String assertApp(String appName, String password, String url) throws IOException {
        FormBody.Builder builder = new FormBody.Builder().add("appName", appName);
        if (password != null) {
            builder.add("password", password);
        }
        return HttpUtils.post((String)url, (RequestBody)builder.build());
    }

    private static String getUrl(String path, String address) {
        return String.format(URL_PATTERN, address, "/openApi", path);
    }

    public ResultDTO<Long> saveJob(SaveJobInfoRequest request) {
        request.setAppId(this.appId);
        MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
        String json = JSON.toJSONString((Object)request);
        String post = this.postHA("/saveJob", RequestBody.create((MediaType)jsonType, (String)json));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> copyJob(Long jobId) {
        FormBody body = new FormBody.Builder().add("jobId", jobId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/copyJob", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<JobInfoDTO> fetchJob(Long jobId) {
        FormBody body = new FormBody.Builder().add("jobId", jobId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/fetchJob", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.JOB_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<List<JobInfoDTO>> fetchAllJob() {
        FormBody body = new FormBody.Builder().add("appId", this.appId.toString()).build();
        String post = this.postHA("/fetchAllJob", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LIST_JOB_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<List<JobInfoDTO>> queryJob(JobInfoQuery powerQuery) {
        powerQuery.setAppIdEq(this.appId);
        MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
        String json = JsonUtils.toJSONStringUnsafe((Object)powerQuery);
        String post = this.postHA("/queryJob", RequestBody.create((MediaType)jsonType, (String)json));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LIST_JOB_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> disableJob(Long jobId) {
        FormBody body = new FormBody.Builder().add("jobId", jobId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/disableJob", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> enableJob(Long jobId) {
        FormBody body = new FormBody.Builder().add("jobId", jobId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/enableJob", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> deleteJob(Long jobId) {
        FormBody body = new FormBody.Builder().add("jobId", jobId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/deleteJob", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> runJob(Long jobId, String instanceParams, long delayMS) {
        FormBody.Builder builder = new FormBody.Builder().add("jobId", jobId.toString()).add("appId", this.appId.toString()).add("delay", String.valueOf(delayMS));
        if (StringUtils.isNotEmpty((CharSequence)instanceParams)) {
            builder.add("instanceParams", instanceParams);
        }
        String post = this.postHA("/runJob", (RequestBody)builder.build());
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> runJob(Long jobId) {
        return this.runJob(jobId, null, 0L);
    }

    public ResultDTO<Void> stopInstance(Long instanceId) {
        FormBody body = new FormBody.Builder().add("instanceId", instanceId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/stopInstance", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> cancelInstance(Long instanceId) {
        FormBody body = new FormBody.Builder().add("instanceId", instanceId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/cancelInstance", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> retryInstance(Long instanceId) {
        FormBody body = new FormBody.Builder().add("instanceId", instanceId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/retryInstance", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Integer> fetchInstanceStatus(Long instanceId) {
        FormBody body = new FormBody.Builder().add("instanceId", instanceId.toString()).build();
        String post = this.postHA("/fetchInstanceStatus", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.INTEGER_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<InstanceInfoDTO> fetchInstanceInfo(Long instanceId) {
        FormBody body = new FormBody.Builder().add("instanceId", instanceId.toString()).build();
        String post = this.postHA("/fetchInstanceInfo", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.INSTANCE_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> saveWorkflow(SaveWorkflowRequest request) {
        request.setAppId(this.appId);
        MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
        String json = JsonUtils.toJSONStringUnsafe((Object)request);
        String post = this.postHA("/saveWorkflow", RequestBody.create((MediaType)jsonType, (String)json));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> copyWorkflow(Long workflowId) {
        FormBody body = new FormBody.Builder().add("workflowId", workflowId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/copyWorkflow", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<List<WorkflowNodeInfoDTO>> saveWorkflowNode(List<SaveWorkflowNodeRequest> requestList) {
        for (SaveWorkflowNodeRequest saveWorkflowNodeRequest : requestList) {
            saveWorkflowNodeRequest.setAppId(this.appId);
        }
        MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
        String json = JsonUtils.toJSONStringUnsafe(requestList);
        String post = this.postHA("/addWorkflowNode", RequestBody.create((MediaType)jsonType, (String)json));
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.WF_NODE_LIST_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<WorkflowInfoDTO> fetchWorkflow(Long workflowId) {
        FormBody body = new FormBody.Builder().add("workflowId", workflowId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/fetchWorkflow", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.WF_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> disableWorkflow(Long workflowId) {
        FormBody body = new FormBody.Builder().add("workflowId", workflowId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/disableWorkflow", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> enableWorkflow(Long workflowId) {
        FormBody body = new FormBody.Builder().add("workflowId", workflowId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/enableWorkflow", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> deleteWorkflow(Long workflowId) {
        FormBody body = new FormBody.Builder().add("workflowId", workflowId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/deleteWorkflow", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> runWorkflow(Long workflowId, String initParams, long delayMS) {
        FormBody.Builder builder = new FormBody.Builder().add("workflowId", workflowId.toString()).add("appId", this.appId.toString()).add("delay", String.valueOf(delayMS));
        if (StringUtils.isNotEmpty((CharSequence)initParams)) {
            builder.add("initParams", initParams);
        }
        String post = this.postHA("/runWorkflow", (RequestBody)builder.build());
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.LONG_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Long> runWorkflow(Long workflowId) {
        return this.runWorkflow(workflowId, null, 0L);
    }

    public ResultDTO<Void> stopWorkflowInstance(Long wfInstanceId) {
        FormBody body = new FormBody.Builder().add("wfInstanceId", wfInstanceId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/stopWfInstance", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> retryWorkflowInstance(Long wfInstanceId) {
        FormBody body = new FormBody.Builder().add("wfInstanceId", wfInstanceId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/retryWfInstance", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<Void> markWorkflowNodeAsSuccess(Long wfInstanceId, Long nodeId) {
        FormBody body = new FormBody.Builder().add("wfInstanceId", wfInstanceId.toString()).add("nodeId", nodeId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/markWorkflowNodeAsSuccess", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.VOID_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    public ResultDTO<WorkflowInstanceInfoDTO> fetchWorkflowInstanceInfo(Long wfInstanceId) {
        FormBody body = new FormBody.Builder().add("wfInstanceId", wfInstanceId.toString()).add("appId", this.appId.toString()).build();
        String post = this.postHA("/fetchWfInstanceInfo", (RequestBody)body);
        return (ResultDTO)JSON.parseObject((String)post, TypeStore.WF_INSTANCE_RESULT_TYPE, (Feature[])new Feature[0]);
    }

    private String postHA(String path, RequestBody requestBody) {
        String url = PowerJobClient.getUrl(path, this.currentAddress);
        try {
            String res = HttpUtils.post((String)url, (RequestBody)requestBody);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                return res;
            }
        }
        catch (IOException e) {
            log.warn("[PowerJobClient] request url:{} failed, reason is {}.", (Object)url, (Object)e.toString());
        }
        for (String addr : this.allAddress) {
            if (Objects.equals(addr, this.currentAddress)) continue;
            url = PowerJobClient.getUrl(path, addr);
            try {
                String res = HttpUtils.post((String)url, (RequestBody)requestBody);
                if (!StringUtils.isNotEmpty((CharSequence)res)) continue;
                log.warn("[PowerJobClient] server change: from({}) -> to({}).", (Object)this.currentAddress, (Object)addr);
                this.currentAddress = addr;
                return res;
            }
            catch (IOException e) {
                log.warn("[PowerJobClient] request url:{} failed, reason is {}.", (Object)url, (Object)e.toString());
            }
        }
        log.error("[PowerJobClient] do post for path: {} failed because of no server available in {}.", (Object)path, this.allAddress);
        throw new PowerJobException("no server available when send post request");
    }
}

