/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.client.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.client.ClientConfig;
import tech.powerjob.client.TypeStore;
import tech.powerjob.client.module.AppAuthRequest;
import tech.powerjob.client.module.AppAuthResult;
import tech.powerjob.client.service.HttpResponse;
import tech.powerjob.client.service.PowerRequestBody;
import tech.powerjob.client.service.impl.ClusterRequestService;
import tech.powerjob.common.enums.EncryptType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.utils.DigestUtils;
import tech.powerjob.common.utils.MapUtils;

abstract class AppAuthClusterRequestService
extends ClusterRequestService {
    private static final Logger log = LoggerFactory.getLogger(AppAuthClusterRequestService.class);
    protected AppAuthResult appAuthResult;

    public AppAuthClusterRequestService(ClientConfig config) {
        super(config);
    }

    @Override
    public String request(String path, PowerRequestBody powerRequestBody) {
        if (this.appAuthResult == null) {
            this.refreshAppAuthResult();
        }
        HttpResponse httpResponse = this.doRequest(path, powerRequestBody);
        String authStatus = MapUtils.getString(httpResponse.getHeaders(), (Object)"X-POWERJOB-AUTH-PASSED");
        if (Boolean.TRUE.toString().equalsIgnoreCase(authStatus)) {
            return httpResponse.getResponse();
        }
        log.warn("[PowerJobClient] auth failed[authStatus: {}], try to refresh the auth info", (Object)authStatus);
        this.refreshAppAuthResult();
        httpResponse = this.doRequest(path, powerRequestBody);
        return httpResponse.getResponse();
    }

    private HttpResponse doRequest(String path, PowerRequestBody powerRequestBody) {
        Map<String, String> authHeaders = this.buildAuthHeader();
        powerRequestBody.addHeaders(authHeaders);
        HttpResponse httpResponse = this.clusterHaRequest(path, powerRequestBody);
        if (!httpResponse.isSuccess()) {
            throw new PowerJobException("REMOTE_SERVER_INNER_EXCEPTION");
        }
        return httpResponse;
    }

    private Map<String, String> buildAuthHeader() {
        HashMap authHeader = Maps.newHashMap();
        authHeader.put("X-POWERJOB-APP-ID", String.valueOf(this.appAuthResult.getAppId()));
        authHeader.put("X-POWERJOB-ACCESS-TOKEN", this.appAuthResult.getToken());
        return authHeader;
    }

    private void refreshAppAuthResult() {
        AppAuthRequest appAuthRequest = this.buildAppAuthRequest();
        HttpResponse httpResponse = this.clusterHaRequest("/authApp", PowerRequestBody.newJsonRequestBody(appAuthRequest));
        if (!httpResponse.isSuccess()) {
            throw new PowerJobException("AUTH_APP_EXCEPTION!");
        }
        ResultDTO authResultDTO = (ResultDTO)JSONObject.parseObject((String)httpResponse.getResponse(), TypeStore.APP_AUTH_RESULT_TYPE, (Feature[])new Feature[0]);
        if (!authResultDTO.isSuccess()) {
            throw new PowerJobException("AUTH_FAILED_" + authResultDTO.getMessage());
        }
        log.warn("[PowerJobClient] refresh auth info successfully!");
        this.appAuthResult = (AppAuthResult)authResultDTO.getData();
    }

    protected AppAuthRequest buildAppAuthRequest() {
        AppAuthRequest appAuthRequest = new AppAuthRequest();
        appAuthRequest.setAppName(this.config.getAppName());
        appAuthRequest.setEncryptedPassword(DigestUtils.md5((String)this.config.getPassword()));
        appAuthRequest.setEncryptType(EncryptType.MD5.getCode());
        return appAuthRequest;
    }
}

