/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    private static final int RND_PORT_START = 30000;
    private static final int RND_PORT_END = 65535;
    private static volatile String HOST_ADDRESS;
    private static final String LOCALHOST_VALUE = "127.0.0.1";
    private static volatile InetAddress LOCAL_ADDRESS;
    private static final Pattern IP_PATTERN;
    private static final String ANYHOST_VALUE = "0.0.0.0";

    public static int getRandomPort() {
        return ThreadLocalRandom.current().nextInt(30000, 65535);
    }

    public static String getLocalHost() {
        if (HOST_ADDRESS != null) {
            return HOST_ADDRESS;
        }
        String addressFromJVM = System.getProperty("powerjob.network.local.address");
        if (StringUtils.isNotEmpty((CharSequence)addressFromJVM)) {
            log.info("[Net] use address from[{}]: {}", (Object)"powerjob.network.local.address", (Object)addressFromJVM);
            HOST_ADDRESS = addressFromJVM;
            return HOST_ADDRESS;
        }
        InetAddress address = NetUtils.getLocalAddress();
        if (address != null) {
            HOST_ADDRESS = address.getHostAddress();
            return HOST_ADDRESS;
        }
        return LOCALHOST_VALUE;
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            NetworkInterface networkInterface = NetUtils.findNetworkInterface();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
                if (!addressOp.isPresent()) continue;
                try {
                    if (!addressOp.get().isReachable(100)) continue;
                    return addressOp.get();
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (Throwable e) {
            log.warn("[Net] getLocalAddress0 failed.", e);
        }
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Throwable e) {
            log.warn("[Net] getLocalAddress0 failed.", e);
        }
        return localAddress;
    }

    public static NetworkInterface findNetworkInterface() {
        List<Object> validNetworkInterfaces = Collections.emptyList();
        try {
            validNetworkInterfaces = NetUtils.getValidNetworkInterfaces();
        }
        catch (Throwable e) {
            log.warn("[Net] findNetworkInterface failed", e);
        }
        NetworkInterface result = null;
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!NetUtils.isPreferredNetworkInterface(networkInterface)) continue;
            result = networkInterface;
            log.info("[Net] use preferred network interface: {}", (Object)networkInterface.getDisplayName());
            break;
        }
        if (result == null) {
            block5: for (NetworkInterface networkInterface : validNetworkInterfaces) {
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
                    if (!addressOp.isPresent()) continue;
                    try {
                        if (!addressOp.get().isReachable(100)) continue;
                        result = networkInterface;
                        continue block5;
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
        if (result == null) {
            result = (NetworkInterface)NetUtils.first(validNetworkInterfaces);
        }
        return result;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtils.isPreferIPV6Address()) {
                return Optional.ofNullable(NetUtils.normalizeV6Address(v6Address));
            }
        }
        if (NetUtils.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !ANYHOST_VALUE.equals(name) && !LOCALHOST_VALUE.equals(name);
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    private static List<NetworkInterface> getValidNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (NetUtils.ignoreNetworkInterface(networkInterface) || NetUtils.ignoreInterfaceByConfig(networkInterface.getDisplayName()) || NetUtils.ignoreInterfaceByConfig(networkInterface.getName())) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    private static boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        return networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
    }

    public static <T> T first(Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values instanceof List) {
            List list = (List)values;
            return (T)list.get(0);
        }
        return values.iterator().next();
    }

    public static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty("powerjob.network.interface.preferred");
        if (Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface)) {
            return true;
        }
        return Objects.equals(networkInterface.getName(), preferredNetworkInterface);
    }

    public static Pair<String, Integer> splitAddress2IpAndPort(String address) {
        String[] split = address.split(":");
        return Pair.of((Object)split[0], (Object)Integer.valueOf(split[1]));
    }

    static boolean ignoreInterfaceByConfig(String interfaceName) {
        String regex = System.getProperty("powerjob.network.interface.ignored");
        if (StringUtils.isBlank((CharSequence)regex)) {
            return false;
        }
        if (interfaceName.matches(regex)) {
            log.info("[Net] ignore network interface: {} by regex({})", (Object)interfaceName, (Object)regex);
            return true;
        }
        return false;
    }

    static {
        LOCAL_ADDRESS = null;
        IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    }
}

