/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.net.PingPongServer;

public class PingPongSocketServer
implements PingPongServer {
    private static final Logger log = LoggerFactory.getLogger(PingPongSocketServer.class);
    private Thread thread;
    private ServerSocket serverSocket;
    private volatile boolean terminated = false;

    @Override
    public void initialize(int port) throws Exception {
        this.serverSocket = new ServerSocket(port);
        this.thread = new Thread(() -> {
            while (!this.terminated) {
                try {
                    Socket socket = this.serverSocket.accept();
                    Throwable throwable = null;
                    try {
                        OutputStream outputStream = socket.getOutputStream();
                        Throwable throwable2 = null;
                        try {
                            socket.setSoTimeout(2000);
                            socket.setKeepAlive(false);
                            outputStream.write("pong".getBytes(StandardCharsets.UTF_8));
                            outputStream.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
                            outputStream.flush();
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (outputStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            outputStream.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (socket == null) continue;
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        socket.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    if (this.terminated) continue;
                    log.warn("[PingPongSocketServer] process accepted socket failed!", (Throwable)e);
                    continue;
                }
                break;
            }
            return;
        }, "PingPongSocketServer-Thread");
        this.thread.start();
    }

    @Override
    public void close() throws IOException {
        this.terminated = true;
        CommonUtils.executeIgnoreException(() -> this.serverSocket.close());
        this.thread.interrupt();
    }
}

