/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.model;

import lombok.Generated;
import tech.powerjob.common.PowerSerializable;

public class SystemMetrics
implements PowerSerializable,
Comparable<SystemMetrics> {
    private int cpuProcessors;
    private double cpuLoad;
    private double jvmUsedMemory;
    private double jvmMaxMemory;
    private double jvmMemoryUsage;
    private double diskUsed;
    private double diskTotal;
    private double diskUsage;
    private String extra;
    private int score;

    @Override
    public int compareTo(SystemMetrics that) {
        return that.calculateScore() - this.calculateScore();
    }

    public int calculateScore() {
        if (this.score > 0) {
            return this.score;
        }
        double memScore = (this.jvmMaxMemory - this.jvmUsedMemory) * 2.0;
        double cpuScore = (double)this.cpuProcessors - this.cpuLoad;
        if (cpuScore > (double)this.cpuProcessors) {
            cpuScore = 1.0;
        }
        this.score = (int)(memScore + cpuScore);
        return this.score;
    }

    public boolean available(double minCPUCores, double minMemorySpace, double minDiskSpace) {
        double availableMemory = this.jvmMaxMemory - this.jvmUsedMemory;
        double availableDisk = this.diskTotal - this.diskUsed;
        if (availableMemory < minMemorySpace || availableDisk < minDiskSpace) {
            return false;
        }
        if (this.cpuLoad <= 0.0 || minCPUCores <= 0.0) {
            return true;
        }
        return minCPUCores < (double)this.cpuProcessors - this.cpuLoad;
    }

    @Generated
    public SystemMetrics() {
    }

    @Generated
    public int getCpuProcessors() {
        return this.cpuProcessors;
    }

    @Generated
    public double getCpuLoad() {
        return this.cpuLoad;
    }

    @Generated
    public double getJvmUsedMemory() {
        return this.jvmUsedMemory;
    }

    @Generated
    public double getJvmMaxMemory() {
        return this.jvmMaxMemory;
    }

    @Generated
    public double getJvmMemoryUsage() {
        return this.jvmMemoryUsage;
    }

    @Generated
    public double getDiskUsed() {
        return this.diskUsed;
    }

    @Generated
    public double getDiskTotal() {
        return this.diskTotal;
    }

    @Generated
    public double getDiskUsage() {
        return this.diskUsage;
    }

    @Generated
    public String getExtra() {
        return this.extra;
    }

    @Generated
    public int getScore() {
        return this.score;
    }

    @Generated
    public void setCpuProcessors(int cpuProcessors) {
        this.cpuProcessors = cpuProcessors;
    }

    @Generated
    public void setCpuLoad(double cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    @Generated
    public void setJvmUsedMemory(double jvmUsedMemory) {
        this.jvmUsedMemory = jvmUsedMemory;
    }

    @Generated
    public void setJvmMaxMemory(double jvmMaxMemory) {
        this.jvmMaxMemory = jvmMaxMemory;
    }

    @Generated
    public void setJvmMemoryUsage(double jvmMemoryUsage) {
        this.jvmMemoryUsage = jvmMemoryUsage;
    }

    @Generated
    public void setDiskUsed(double diskUsed) {
        this.diskUsed = diskUsed;
    }

    @Generated
    public void setDiskTotal(double diskTotal) {
        this.diskTotal = diskTotal;
    }

    @Generated
    public void setDiskUsage(double diskUsage) {
        this.diskUsage = diskUsage;
    }

    @Generated
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Generated
    public void setScore(int score) {
        this.score = score;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemMetrics)) {
            return false;
        }
        SystemMetrics other = (SystemMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCpuProcessors() != other.getCpuProcessors()) {
            return false;
        }
        if (Double.compare(this.getCpuLoad(), other.getCpuLoad()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmUsedMemory(), other.getJvmUsedMemory()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmMaxMemory(), other.getJvmMaxMemory()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmMemoryUsage(), other.getJvmMemoryUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskUsed(), other.getDiskUsed()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskTotal(), other.getDiskTotal()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskUsage(), other.getDiskUsage()) != 0) {
            return false;
        }
        if (this.getScore() != other.getScore()) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SystemMetrics;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCpuProcessors();
        long $cpuLoad = Double.doubleToLongBits(this.getCpuLoad());
        result = result * 59 + (int)($cpuLoad >>> 32 ^ $cpuLoad);
        long $jvmUsedMemory = Double.doubleToLongBits(this.getJvmUsedMemory());
        result = result * 59 + (int)($jvmUsedMemory >>> 32 ^ $jvmUsedMemory);
        long $jvmMaxMemory = Double.doubleToLongBits(this.getJvmMaxMemory());
        result = result * 59 + (int)($jvmMaxMemory >>> 32 ^ $jvmMaxMemory);
        long $jvmMemoryUsage = Double.doubleToLongBits(this.getJvmMemoryUsage());
        result = result * 59 + (int)($jvmMemoryUsage >>> 32 ^ $jvmMemoryUsage);
        long $diskUsed = Double.doubleToLongBits(this.getDiskUsed());
        result = result * 59 + (int)($diskUsed >>> 32 ^ $diskUsed);
        long $diskTotal = Double.doubleToLongBits(this.getDiskTotal());
        result = result * 59 + (int)($diskTotal >>> 32 ^ $diskTotal);
        long $diskUsage = Double.doubleToLongBits(this.getDiskUsage());
        result = result * 59 + (int)($diskUsage >>> 32 ^ $diskUsage);
        result = result * 59 + this.getScore();
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SystemMetrics(cpuProcessors=" + this.getCpuProcessors() + ", cpuLoad=" + this.getCpuLoad() + ", jvmUsedMemory=" + this.getJvmUsedMemory() + ", jvmMaxMemory=" + this.getJvmMaxMemory() + ", jvmMemoryUsage=" + this.getJvmMemoryUsage() + ", diskUsed=" + this.getDiskUsed() + ", diskTotal=" + this.getDiskTotal() + ", diskUsage=" + this.getDiskUsage() + ", extra=" + this.getExtra() + ", score=" + this.getScore() + ")";
    }
}

