/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.request;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import tech.powerjob.common.enums.Protocol;

public class ServerDiscoveryRequest
implements Serializable {
    private Long appId;
    private String protocol;
    private String currentServer;
    private String clientVersion;

    public Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (this.appId != null) {
            ret.put("appId", this.appId);
        }
        ret.put("protocol", this.protocol);
        if (StringUtils.isNotEmpty((CharSequence)this.currentServer)) {
            ret.put("currentServer", this.currentServer);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.clientVersion)) {
            ret.put("clientVersion", this.clientVersion);
        }
        return ret;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getProtocol() {
        return Optional.ofNullable(this.protocol).orElse(Protocol.AKKA.name());
    }

    public String getCurrentServer() {
        return this.currentServer;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    @Generated
    public ServerDiscoveryRequest setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    @Generated
    public ServerDiscoveryRequest setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    public ServerDiscoveryRequest setCurrentServer(String currentServer) {
        this.currentServer = currentServer;
        return this;
    }

    @Generated
    public ServerDiscoveryRequest setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }
}

