/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JavaUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String determinePackageVersion(Class<?> clz) {
        try {
            String implementationVersion = clz.getPackage().getImplementationVersion();
            if (implementationVersion != null) {
                return implementationVersion;
            }
            CodeSource codeSource = clz.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL codeSourceLocation = codeSource.getLocation();
            URLConnection connection = codeSourceLocation.openConnection();
            if (connection instanceof JarURLConnection) {
                return JavaUtils.getImplementationVersion(((JarURLConnection)connection).getJarFile());
            }
            File file = new File(codeSourceLocation.toURI());
            if (!file.exists()) return "UNKNOWN";
            if (file.isDirectory()) {
                return "UNKNOWN";
            }
            try (JarFile jarFile = new JarFile(file);){
                String string = JavaUtils.getImplementationVersion(jarFile);
                return string;
            }
        }
        catch (Throwable t) {
            log.warn("[JavaUtils] determinePackageVersion for clz[{}] failed, msg: {}", (Object)clz.getSimpleName(), (Object)t.toString());
            return "UNKNOWN";
        }
    }

    private static String getImplementationVersion(JarFile jarFile) throws IOException {
        return jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

