/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import shade.powerjob.com.alibaba.fastjson.JSON;
import shade.powerjob.com.alibaba.fastjson.JSONObject;
import shade.powerjob.com.alibaba.fastjson.JSONValidator;
import shade.powerjob.okhttp3.MediaType;
import shade.powerjob.okhttp3.OkHttpClient;
import shade.powerjob.okhttp3.Request;
import shade.powerjob.okhttp3.RequestBody;
import shade.powerjob.okhttp3.Response;
import shade.powerjob.org.apache.commons.lang3.StringUtils;
import tech.powerjob.official.processors.CommonBasicProcessor;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.log.OmsLogger;

public class HttpProcessor
extends CommonBasicProcessor {
    private static final int DEFAULT_TIMEOUT = 60;
    private static final int HTTP_SUCCESS_CODE = 200;
    private static final Map<Integer, OkHttpClient> CLIENT_STORE = new ConcurrentHashMap<Integer, OkHttpClient>();

    @Override
    public ProcessResult process0(TaskContext taskContext) throws Exception {
        OmsLogger omsLogger = taskContext.getOmsLogger();
        HttpParams httpParams = JSON.parseObject(CommonUtils.parseParams(taskContext), HttpParams.class);
        if (httpParams == null) {
            String message = "httpParams is null, please check jobParam configuration.";
            omsLogger.warn(message, new Object[0]);
            return new ProcessResult(false, message);
        }
        if (StringUtils.isEmpty(httpParams.url)) {
            return new ProcessResult(false, "url can't be empty!");
        }
        if (!httpParams.url.startsWith("http")) {
            httpParams.url = "http://" + httpParams.url;
        }
        omsLogger.info("request url: {}", new Object[]{httpParams.url});
        if (StringUtils.isEmpty(httpParams.method)) {
            httpParams.method = "GET";
            omsLogger.info("using default request method: GET", new Object[0]);
        } else {
            httpParams.method = httpParams.method.toUpperCase();
            omsLogger.info("request method: {}", new Object[]{httpParams.method});
        }
        if (!"GET".equals(httpParams.method)) {
            if (StringUtils.isEmpty(httpParams.body)) {
                httpParams.body = new JSONObject().toJSONString();
                omsLogger.warn("try to use default request body:{}", new Object[]{httpParams.body});
            }
            if (JSONValidator.from(httpParams.body).validate() && StringUtils.isEmpty(httpParams.mediaType)) {
                httpParams.mediaType = "application/json";
                omsLogger.warn("try to use 'application/json' as media type", new Object[0]);
            }
        }
        if (httpParams.timeout == null) {
            httpParams.timeout = 60;
        }
        omsLogger.info("request timeout: {} seconds", new Object[]{httpParams.timeout});
        OkHttpClient client = HttpProcessor.getClient(httpParams.timeout);
        Request.Builder builder = new Request.Builder().url(httpParams.url);
        if (httpParams.headers != null) {
            httpParams.headers.forEach((k, v) -> {
                builder.addHeader((String)k, (String)v);
                omsLogger.info("add header {}:{}", new Object[]{k, v});
            });
        }
        switch (httpParams.method) {
            case "PUT": 
            case "DELETE": 
            case "POST": {
                MediaType mediaType = MediaType.parse(httpParams.mediaType);
                omsLogger.info("mediaType: {}", new Object[]{mediaType});
                RequestBody requestBody = RequestBody.create(mediaType, httpParams.body);
                builder.method(httpParams.method, requestBody);
                break;
            }
            default: {
                builder.get();
            }
        }
        Response response = client.newCall(builder.build()).execute();
        omsLogger.info("response: {}", new Object[]{response});
        String msgBody = "";
        if (response.body() != null) {
            msgBody = response.body().string();
        }
        int responseCode = response.code();
        String res = String.format("code:%d, body:%s", responseCode, msgBody);
        boolean success = true;
        if (responseCode != 200) {
            success = false;
            omsLogger.warn("{} url: {} failed, response code is {}, response body is {}", new Object[]{httpParams.method, httpParams.url, responseCode, msgBody});
        }
        return new ProcessResult(success, res);
    }

    private static OkHttpClient getClient(Integer timeout) {
        return CLIENT_STORE.computeIfAbsent(timeout, ignore -> new OkHttpClient.Builder().connectTimeout(Duration.ZERO).readTimeout(Duration.ZERO).writeTimeout(Duration.ZERO).callTimeout(timeout.intValue(), TimeUnit.SECONDS).build());
    }

    public static class HttpParams {
        private String method;
        private String url;
        private String mediaType;
        private String body;
        private Map<String, String> headers;
        private Integer timeout;

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String getBody() {
            return this.body;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpParams)) {
                return false;
            }
            HttpParams other = (HttpParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$mediaType = this.getMediaType();
            String other$mediaType = other.getMediaType();
            if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $mediaType = this.getMediaType();
            result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        public String toString() {
            return "HttpProcessor.HttpParams(method=" + this.getMethod() + ", url=" + this.getUrl() + ", mediaType=" + this.getMediaType() + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ", timeout=" + this.getTimeout() + ")";
        }
    }
}

