/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import shade.powerjob.com.alibaba.fastjson.JSONObject;
import shade.powerjob.com.google.common.collect.Lists;
import shade.powerjob.org.apache.commons.lang3.RandomStringUtils;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.official.processors.CommonBasicProcessor;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.TaskResult;
import tech.powerjob.worker.core.processor.sdk.BroadcastProcessor;
import tech.powerjob.worker.core.processor.sdk.MapReduceProcessor;
import tech.powerjob.worker.log.OmsLogger;

public class VerificationProcessor
extends CommonBasicProcessor
implements MapReduceProcessor,
BroadcastProcessor {
    @Override
    protected ProcessResult process0(TaskContext taskContext) throws Exception {
        OmsLogger omsLogger = taskContext.getOmsLogger();
        String paramsStr = CommonUtils.parseParams(taskContext);
        VerificationParam verificationParam = JSONObject.parseObject(paramsStr, VerificationParam.class);
        Mode mode = Mode.of(verificationParam.getMode());
        switch (mode) {
            case ERROR: {
                return new ProcessResult(false, "EXECUTE_FAILED_FOR_TEST");
            }
            case EXCEPTION: {
                throw new PowerJobException("exception for test");
            }
            case TIMEOUT: {
                Long sleepMs = Optional.ofNullable(verificationParam.getSleepMs()).orElse(3600000L);
                Thread.sleep(sleepMs);
                return new ProcessResult(true, "AFTER_SLEEP_" + sleepMs);
            }
            case RETRY: {
                int currentRetryTimes = taskContext.getCurrentRetryTimes();
                int maxRetryTimes = taskContext.getMaxRetryTimes();
                omsLogger.info("[Retry] currentRetryTimes: {}, maxRetryTimes: {}", new Object[]{currentRetryTimes, maxRetryTimes});
                if (currentRetryTimes < maxRetryTimes) {
                    Thread.sleep(100L);
                    omsLogger.info("[Retry] currentRetryTimes[{}] < maxRetryTimes[{}], return failed status!", new Object[]{currentRetryTimes, maxRetryTimes});
                    return new ProcessResult(false, "FAILED_UNTIL_LAST_RETRY_" + currentRetryTimes);
                }
                omsLogger.info("[Retry] last retry, return success status!", new Object[0]);
                return new ProcessResult(true, "RETRY_SUCCESSFULLY!");
            }
            case MR: {
                if (this.isRootTask()) {
                    int batchNum = Optional.ofNullable(verificationParam.getBatchNum()).orElse(10);
                    int batchSize = Optional.ofNullable(verificationParam.getBatchSize()).orElse(100);
                    omsLogger.info("[VerificationProcessor] start root task~", new Object[0]);
                    ArrayList<TestSubTask> subTasks = new ArrayList<TestSubTask>();
                    for (int a = 0; a < batchNum; ++a) {
                        for (int b = 0; b < batchSize; ++b) {
                            int x = a * batchSize + b;
                            subTasks.add(new TestSubTask("task_" + x, x));
                        }
                        this.map(subTasks, "MAP_TEST_TASK_" + a);
                        omsLogger.info("[VerificationProcessor] [{}] map one batch successfully~", new Object[]{batchNum});
                        subTasks.clear();
                    }
                    omsLogger.info("[VerificationProcessor] all map successfully!", new Object[0]);
                    return new ProcessResult(true, "MAP_SUCCESS");
                }
                String taskId = taskContext.getTaskId();
                Double successRate = Optional.ofNullable(verificationParam.getSubTaskSuccessRate()).orElse(0.5);
                double rd = ThreadLocalRandom.current().nextDouble(0.0, 1.0);
                boolean success = rd <= successRate;
                long processCost = ThreadLocalRandom.current().nextLong(277L);
                Thread.sleep(processCost);
                omsLogger.info("[VerificationProcessor] [MR] taskId:{}, processCost: {}, success:{}", new Object[]{taskId, processCost, success});
                return new ProcessResult(success, RandomStringUtils.randomAlphanumeric(3));
            }
        }
        String randomMsg = RandomStringUtils.randomAlphanumeric(Optional.ofNullable(verificationParam.getResponseSize()).orElse(10));
        omsLogger.info("generate random string: {}", new Object[]{randomMsg});
        return new ProcessResult(true, "EXECUTE_SUCCESSFULLY_" + randomMsg);
    }

    public ProcessResult reduce(TaskContext context, List<TaskResult> taskResults) {
        ArrayList successTaskIds = Lists.newArrayList();
        ArrayList failedTaskIds = Lists.newArrayList();
        StringBuilder sb = new StringBuilder();
        taskResults.forEach(taskResult -> {
            sb.append("tId:").append(taskResult.getTaskId()).append(";").append("tSuc:").append(taskResult.isSuccess()).append(";").append("tRes:").append(taskResult.getResult());
            if (taskResult.isSuccess()) {
                successTaskIds.add(taskResult.getTaskId());
            } else {
                failedTaskIds.add(taskResult.getTaskId());
            }
        });
        context.getOmsLogger().info("[Reduce] [summary] successTaskNum: {}, failedTaskNum: {}, successRate: {}", new Object[]{successTaskIds.size(), failedTaskIds.size(), 1.0 * (double)successTaskIds.size() / (double)(successTaskIds.size() + failedTaskIds.size())});
        context.getOmsLogger().info("[Reduce] successTaskIds: {}", new Object[]{successTaskIds});
        context.getOmsLogger().info("[Reduce] failedTaskIds: {}", new Object[]{failedTaskIds});
        return new ProcessResult(true, sb.toString());
    }

    public ProcessResult preProcess(TaskContext context) throws Exception {
        context.getOmsLogger().info("start to preProcess, current worker IP is {}.", new Object[]{NetUtils.getLocalHost()});
        return new ProcessResult(true, "preProcess successfully!");
    }

    public ProcessResult postProcess(TaskContext context, List<TaskResult> taskResults) throws Exception {
        OmsLogger omsLogger = context.getOmsLogger();
        omsLogger.info("start to postProcess, current worker IP is {}.", new Object[]{NetUtils.getLocalHost()});
        omsLogger.info("====== All Node's Process Result ======", new Object[0]);
        taskResults.forEach(r -> omsLogger.info("taskId:{},success:{},result:{}", new Object[]{r.getTaskId(), r.isSuccess(), r.getResult()}));
        return new ProcessResult(true, "postProcess successfully!");
    }

    public static class TestSubTask {
        private String taskName;
        private int id;

        public String getTaskName() {
            return this.taskName;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "VerificationProcessor.TestSubTask(taskName=" + this.getTaskName() + ", id=" + this.getId() + ")";
        }

        public TestSubTask() {
        }

        public TestSubTask(String taskName, int id) {
            this.taskName = taskName;
            this.id = id;
        }
    }

    public static class VerificationParam
    implements Serializable {
        private String mode;
        private Long sleepMs;
        private Integer batchSize;
        private Integer batchNum;
        private Double subTaskSuccessRate;
        private Integer responseSize;

        public String getMode() {
            return this.mode;
        }

        public Long getSleepMs() {
            return this.sleepMs;
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public Integer getBatchNum() {
            return this.batchNum;
        }

        public Double getSubTaskSuccessRate() {
            return this.subTaskSuccessRate;
        }

        public Integer getResponseSize() {
            return this.responseSize;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public void setSleepMs(Long sleepMs) {
            this.sleepMs = sleepMs;
        }

        public void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public void setBatchNum(Integer batchNum) {
            this.batchNum = batchNum;
        }

        public void setSubTaskSuccessRate(Double subTaskSuccessRate) {
            this.subTaskSuccessRate = subTaskSuccessRate;
        }

        public void setResponseSize(Integer responseSize) {
            this.responseSize = responseSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerificationParam)) {
                return false;
            }
            VerificationParam other = (VerificationParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mode = this.getMode();
            String other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                return false;
            }
            Long this$sleepMs = this.getSleepMs();
            Long other$sleepMs = other.getSleepMs();
            if (this$sleepMs == null ? other$sleepMs != null : !((Object)this$sleepMs).equals(other$sleepMs)) {
                return false;
            }
            Integer this$batchSize = this.getBatchSize();
            Integer other$batchSize = other.getBatchSize();
            if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
                return false;
            }
            Integer this$batchNum = this.getBatchNum();
            Integer other$batchNum = other.getBatchNum();
            if (this$batchNum == null ? other$batchNum != null : !((Object)this$batchNum).equals(other$batchNum)) {
                return false;
            }
            Double this$subTaskSuccessRate = this.getSubTaskSuccessRate();
            Double other$subTaskSuccessRate = other.getSubTaskSuccessRate();
            if (this$subTaskSuccessRate == null ? other$subTaskSuccessRate != null : !((Object)this$subTaskSuccessRate).equals(other$subTaskSuccessRate)) {
                return false;
            }
            Integer this$responseSize = this.getResponseSize();
            Integer other$responseSize = other.getResponseSize();
            return !(this$responseSize == null ? other$responseSize != null : !((Object)this$responseSize).equals(other$responseSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerificationParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            Long $sleepMs = this.getSleepMs();
            result = result * 59 + ($sleepMs == null ? 43 : ((Object)$sleepMs).hashCode());
            Integer $batchSize = this.getBatchSize();
            result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
            Integer $batchNum = this.getBatchNum();
            result = result * 59 + ($batchNum == null ? 43 : ((Object)$batchNum).hashCode());
            Double $subTaskSuccessRate = this.getSubTaskSuccessRate();
            result = result * 59 + ($subTaskSuccessRate == null ? 43 : ((Object)$subTaskSuccessRate).hashCode());
            Integer $responseSize = this.getResponseSize();
            result = result * 59 + ($responseSize == null ? 43 : ((Object)$responseSize).hashCode());
            return result;
        }

        public String toString() {
            return "VerificationProcessor.VerificationParam(mode=" + this.getMode() + ", sleepMs=" + this.getSleepMs() + ", batchSize=" + this.getBatchSize() + ", batchNum=" + this.getBatchNum() + ", subTaskSuccessRate=" + this.getSubTaskSuccessRate() + ", responseSize=" + this.getResponseSize() + ")";
        }
    }

    static enum Mode {
        BASE,
        TIMEOUT,
        ERROR,
        EXCEPTION,
        MR,
        RETRY;


        public static Mode of(String v) {
            for (Mode m : Mode.values()) {
                if (!m.name().equalsIgnoreCase(v)) continue;
                return m;
            }
            return BASE;
        }
    }
}

