/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.framework;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.remote.framework.actor.Handler;

@Actor(path="benchmark")
public class BenchmarkActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BenchmarkActor.class);

    @Handler(path="standard")
    public BenchmarkResponse standardRequest(BenchmarkRequest request) {
        long startTs = System.currentTimeMillis();
        log.info("[BenchmarkActor] [standardRequest] receive request: {}", (Object)request);
        BenchmarkResponse response = new BenchmarkResponse().setSuccess(true).setContent(request.getContent()).setProcessThread(Thread.currentThread().getName()).setServerReceiveTs(System.currentTimeMillis());
        if (request.getResponseSize() != null && request.getResponseSize() > 0) {
            response.setExtra(RandomStringUtils.randomPrint((int)request.getResponseSize()));
        }
        BenchmarkActor.executeSleep(request);
        response.setServerCost(System.currentTimeMillis() - startTs);
        return response;
    }

    @Handler(path="emptyReturn")
    public void emptyReturn(BenchmarkRequest request) {
        log.info("[BenchmarkActor] [emptyReturn] receive request: {}", (Object)request);
        BenchmarkActor.executeSleep(request);
    }

    @Handler(path="stringReturn")
    public String stringReturn(BenchmarkRequest request) {
        log.info("[BenchmarkActor] [stringReturn] receive request: {}", (Object)request);
        BenchmarkActor.executeSleep(request);
        return RandomStringUtils.randomPrint((int)Optional.ofNullable(request.getResponseSize()).orElse(100));
    }

    private static void executeSleep(BenchmarkRequest request) {
        if (request.getBlockingMills() != null && request.getBlockingMills() > 0) {
            CommonUtils.easySleep((long)request.getBlockingMills().intValue());
        }
    }

    public static class BenchmarkResponse
    implements PowerSerializable {
        private boolean success;
        private String content;
        private String processThread;
        private long serverReceiveTs;
        private long serverCost;
        private String extra;

        @Generated
        public BenchmarkResponse() {
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public String getProcessThread() {
            return this.processThread;
        }

        @Generated
        public long getServerReceiveTs() {
            return this.serverReceiveTs;
        }

        @Generated
        public long getServerCost() {
            return this.serverCost;
        }

        @Generated
        public String getExtra() {
            return this.extra;
        }

        @Generated
        public BenchmarkResponse setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        @Generated
        public BenchmarkResponse setContent(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public BenchmarkResponse setProcessThread(String processThread) {
            this.processThread = processThread;
            return this;
        }

        @Generated
        public BenchmarkResponse setServerReceiveTs(long serverReceiveTs) {
            this.serverReceiveTs = serverReceiveTs;
            return this;
        }

        @Generated
        public BenchmarkResponse setServerCost(long serverCost) {
            this.serverCost = serverCost;
            return this;
        }

        @Generated
        public BenchmarkResponse setExtra(String extra) {
            this.extra = extra;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BenchmarkResponse)) {
                return false;
            }
            BenchmarkResponse other = (BenchmarkResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.getServerReceiveTs() != other.getServerReceiveTs()) {
                return false;
            }
            if (this.getServerCost() != other.getServerCost()) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$processThread = this.getProcessThread();
            String other$processThread = other.getProcessThread();
            if (this$processThread == null ? other$processThread != null : !this$processThread.equals(other$processThread)) {
                return false;
            }
            String this$extra = this.getExtra();
            String other$extra = other.getExtra();
            return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BenchmarkResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            long $serverReceiveTs = this.getServerReceiveTs();
            result = result * 59 + (int)($serverReceiveTs >>> 32 ^ $serverReceiveTs);
            long $serverCost = this.getServerCost();
            result = result * 59 + (int)($serverCost >>> 32 ^ $serverCost);
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $processThread = this.getProcessThread();
            result = result * 59 + ($processThread == null ? 43 : $processThread.hashCode());
            String $extra = this.getExtra();
            result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BenchmarkActor.BenchmarkResponse(success=" + this.isSuccess() + ", content=" + this.getContent() + ", processThread=" + this.getProcessThread() + ", serverReceiveTs=" + this.getServerReceiveTs() + ", serverCost=" + this.getServerCost() + ", extra=" + this.getExtra() + ")";
        }
    }

    public static class BenchmarkRequest
    implements PowerSerializable {
        private String content;
        private Integer responseSize;
        private Integer blockingMills;

        @Generated
        public BenchmarkRequest() {
        }

        @Generated
        public String getContent() {
            return this.content;
        }

        @Generated
        public Integer getResponseSize() {
            return this.responseSize;
        }

        @Generated
        public Integer getBlockingMills() {
            return this.blockingMills;
        }

        @Generated
        public BenchmarkRequest setContent(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public BenchmarkRequest setResponseSize(Integer responseSize) {
            this.responseSize = responseSize;
            return this;
        }

        @Generated
        public BenchmarkRequest setBlockingMills(Integer blockingMills) {
            this.blockingMills = blockingMills;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BenchmarkRequest)) {
                return false;
            }
            BenchmarkRequest other = (BenchmarkRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$responseSize = this.getResponseSize();
            Integer other$responseSize = other.getResponseSize();
            if (this$responseSize == null ? other$responseSize != null : !((Object)this$responseSize).equals(other$responseSize)) {
                return false;
            }
            Integer this$blockingMills = this.getBlockingMills();
            Integer other$blockingMills = other.getBlockingMills();
            if (this$blockingMills == null ? other$blockingMills != null : !((Object)this$blockingMills).equals(other$blockingMills)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BenchmarkRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $responseSize = this.getResponseSize();
            result = result * 59 + ($responseSize == null ? 43 : ((Object)$responseSize).hashCode());
            Integer $blockingMills = this.getBlockingMills();
            result = result * 59 + ($blockingMills == null ? 43 : ((Object)$blockingMills).hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BenchmarkActor.BenchmarkRequest(content=" + this.getContent() + ", responseSize=" + this.getResponseSize() + ", blockingMills=" + this.getBlockingMills() + ")";
        }
    }
}

