/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.framework.engine.impl;

import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.remote.framework.cs.CSInitializer;

class CSInitializerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CSInitializerFactory.class);
    private static final String OFFICIAL_HTTP_CS_INITIALIZER = "tech.powerjob.remote.http.HttpVertxCSInitializer";
    private static final String OFFICIAL_HTTP_CS_INITIALIZER2 = "tech.powerjob.remote.http.HttpCSInitializer";
    private static final String OFFICIAL_AKKA_CS_INITIALIZER = "tech.powerjob.remote.akka.AkkaCSInitializer";
    private static final String OFFICIAL_MU_CS_INITIALIZER = "tech.powerjob.remote.mu.MuCSInitializer";
    private static final String EXTEND_CS_INITIALIZER_PATTERN = "tech.powerjob.remote.%s.CSInitializer";

    CSInitializerFactory() {
    }

    static CSInitializer build(String targetType) {
        CSInitializer officialCSInitializer = CSInitializerFactory.tryLoadCSInitializerByClassName(targetType);
        if (officialCSInitializer != null) {
            return officialCSInitializer;
        }
        log.info("[CSInitializerFactory] try load CSInitializerFactory by name failed, start to use Reflections!");
        Reflections reflections = new Reflections("tech.powerjob", new Scanner[0]);
        Set cSInitializerClzSet = reflections.getSubTypesOf(CSInitializer.class);
        log.info("[CSInitializerFactory] scan subTypeOf CSInitializer: {}", (Object)cSInitializerClzSet);
        for (Class clz : cSInitializerClzSet) {
            try {
                CSInitializer csInitializer = (CSInitializer)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String type = csInitializer.type();
                log.info("[CSInitializerFactory] new instance for CSInitializer[{}] successfully, type={}, object: {}", new Object[]{clz, type, csInitializer});
                if (!targetType.equalsIgnoreCase(type)) continue;
                return csInitializer;
            }
            catch (Exception e) {
                log.error("[CSInitializerFactory] new instance for CSInitializer[{}] failed, maybe you should provide a non-parameter constructor", (Object)clz);
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        throw new PowerJobException(String.format("can't load CSInitializer[%s], ensure your package name start with 'tech.powerjob' and import the dependencies!", targetType));
    }

    private static CSInitializer tryLoadCSInitializerByClassName(String targetType) {
        Optional<CSInitializer> muCSIOpt;
        Optional<CSInitializer> akkaCSIOpt;
        if (Protocol.HTTP.name().equalsIgnoreCase(targetType)) {
            Optional<CSInitializer> httpCsIOpt = CSInitializerFactory.tryLoadCSInitializerByClzName(OFFICIAL_HTTP_CS_INITIALIZER);
            if (httpCsIOpt.isPresent()) {
                return httpCsIOpt.get();
            }
            Optional<CSInitializer> httpCsIOpt2 = CSInitializerFactory.tryLoadCSInitializerByClzName(OFFICIAL_HTTP_CS_INITIALIZER2);
            if (httpCsIOpt2.isPresent()) {
                return httpCsIOpt2.get();
            }
        }
        if (Protocol.AKKA.name().equalsIgnoreCase(targetType) && (akkaCSIOpt = CSInitializerFactory.tryLoadCSInitializerByClzName(OFFICIAL_AKKA_CS_INITIALIZER)).isPresent()) {
            return akkaCSIOpt.get();
        }
        if (Protocol.MU.name().equalsIgnoreCase(targetType) && (muCSIOpt = CSInitializerFactory.tryLoadCSInitializerByClzName(OFFICIAL_MU_CS_INITIALIZER)).isPresent()) {
            return muCSIOpt.get();
        }
        String clz = String.format(EXTEND_CS_INITIALIZER_PATTERN, targetType);
        Optional<CSInitializer> extOpt = CSInitializerFactory.tryLoadCSInitializerByClzName(clz);
        return extOpt.orElse(null);
    }

    private static Optional<CSInitializer> tryLoadCSInitializerByClzName(String clzName) {
        try {
            log.info("[CSInitializerFactory] try to load CSInitializer by classname: {}", (Object)clzName);
            Class<?> clz = Class.forName(clzName);
            CSInitializer o = (CSInitializer)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            log.info("[CSInitializerFactory] load CSInitializer[{}] successfully, obj: {}", (Object)clzName, (Object)o);
            return Optional.of(o);
        }
        catch (ClassNotFoundException ce) {
            log.warn("[CSInitializerFactory] load CSInitializer by classname[{}] failed due to ClassNotFound: {}", (Object)clzName, (Object)ExceptionUtils.getMessage((Throwable)ce));
        }
        catch (Exception e) {
            log.warn("[CSInitializerFactory] load CSInitializer by classname[{}] failed.", (Object)clzName, (Object)e);
        }
        return Optional.empty();
    }
}

