/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.akka;

import com.google.common.collect.Maps;
import java.util.Map;

public class AkkaMappingService {
    private static final Map<String, ActorConfig> RP_2_ACTOR_CFG = Maps.newHashMap();
    private static final String DEFAULT_DISPATCH_NAME = "common-dispatcher";

    public static ActorConfig parseActorName(String actorRootPath) {
        return RP_2_ACTOR_CFG.getOrDefault(actorRootPath, new ActorConfig().setActorName(actorRootPath).setDispatcherName(DEFAULT_DISPATCH_NAME));
    }

    private static void addMappingRule(String newActorPath, String oldActorName, String dispatchName) {
        ActorConfig actorConfig = new ActorConfig().setActorName(oldActorName).setDispatcherName(dispatchName == null ? DEFAULT_DISPATCH_NAME : dispatchName);
        RP_2_ACTOR_CFG.put(newActorPath, actorConfig);
    }

    static {
        AkkaMappingService.addMappingRule("server", "server_actor", "w-r-c-d");
        AkkaMappingService.addMappingRule("friend", "friend_actor", "friend-request-actor-dispatcher");
        AkkaMappingService.addMappingRule("taskTracker", "task_tracker", "task-tracker-dispatcher");
        AkkaMappingService.addMappingRule("processorTracker", "processor_tracker", "processor-tracker-dispatcher");
    }

    public static class ActorConfig {
        private String actorName;
        private String dispatcherName;

        public String getActorName() {
            return this.actorName;
        }

        public String getDispatcherName() {
            return this.dispatcherName;
        }

        public ActorConfig setActorName(String actorName) {
            this.actorName = actorName;
            return this;
        }

        public ActorConfig setDispatcherName(String dispatcherName) {
            this.dispatcherName = dispatcherName;
            return this;
        }
    }
}

