/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.akka;

import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.pattern.Patterns;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.remote.akka.AkkaConstant;
import tech.powerjob.remote.akka.AkkaMappingService;
import tech.powerjob.remote.akka.AkkaProtocol;
import tech.powerjob.remote.framework.base.HandlerLocation;
import tech.powerjob.remote.framework.base.RemotingException;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.remote.framework.transporter.Protocol;
import tech.powerjob.remote.framework.transporter.Transporter;

public class AkkaTransporter
implements Transporter {
    private final ActorSystem actorSystem;
    private static final String AKKA_NODE_PATH = "akka://%s@%s/user/%s";

    public AkkaTransporter(ActorSystem actorSystem) {
        this.actorSystem = actorSystem;
    }

    public Protocol getProtocol() {
        return new AkkaProtocol();
    }

    public void tell(URL url, PowerSerializable request) {
        ActorSelection actorSelection = this.fetchActorSelection(url);
        actorSelection.tell((Object)request, null);
    }

    public <T> CompletionStage<T> ask(URL url, PowerSerializable request, Class<T> clz) throws RemotingException {
        ActorSelection actorSelection = this.fetchActorSelection(url);
        return Patterns.ask((ActorSelection)actorSelection, (Object)request, (Duration)Duration.ofMillis(5000L));
    }

    private ActorSelection fetchActorSelection(URL url) {
        HandlerLocation location = url.getLocation();
        String targetActorSystemName = AkkaConstant.fetchActorSystemName(url.getServerType());
        String targetActorName = AkkaMappingService.parseActorName(location.getRootPath()).getActorName();
        CommonUtils.requireNonNull((Object)targetActorName, (String)("can't find actor by URL: " + location));
        String address = url.getAddress().toFullAddress();
        return this.actorSystem.actorSelection(String.format(AKKA_NODE_PATH, targetActorSystemName, address, targetActorName));
    }
}

