/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.auth.interceptor;

import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import tech.powerjob.server.auth.interceptor.ApiPermission;
import tech.powerjob.server.auth.interceptor.GrantPermissionPlugin;

@Aspect
@Component
public class ApiPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiPermissionAspect.class);

    @Pointcut(value="@annotation(ApiPermission)")
    public void apiPermissionPointcut() {
    }

    @AfterReturning(value="apiPermissionPointcut()", returning="result")
    public void doAfterReturningAdvice1(JoinPoint joinPoint, Object result) {
        Object[] args = joinPoint.getArgs();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiPermission annotationAnno = (ApiPermission)AnnotationUtils.getAnnotation((Method)method, ApiPermission.class);
        assert (annotationAnno != null);
        Class<? extends GrantPermissionPlugin> grandPermissionPluginClz = annotationAnno.grandPermissionPlugin();
        try {
            GrantPermissionPlugin grandPermissionPlugin = grandPermissionPluginClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            grandPermissionPlugin.grant(args, result, method, joinPoint.getTarget());
        }
        catch (Exception e) {
            log.error("[ApiPermissionAspect] process ApiPermission grant failed", (Throwable)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

