/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.service;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.server.core.validator.NodeValidator;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;

@Service
public class NodeValidateService {
    private static final Logger log = LoggerFactory.getLogger(NodeValidateService.class);
    private final Map<WorkflowNodeType, NodeValidator> nodeValidatorMap = new EnumMap<WorkflowNodeType, NodeValidator>(WorkflowNodeType.class);

    public NodeValidateService(List<NodeValidator> nodeValidators) {
        nodeValidators.forEach(e -> this.nodeValidatorMap.put(e.matchingType(), (NodeValidator)e));
    }

    public void complexValidate(WorkflowNodeInfoDO node, WorkflowDAG dag) {
        NodeValidator nodeValidator = this.getNodeValidator(node);
        if (nodeValidator == null) {
            return;
        }
        nodeValidator.complexValidate(node, dag);
    }

    public void simpleValidate(WorkflowNodeInfoDO node) {
        NodeValidator nodeValidator = this.getNodeValidator(node);
        if (nodeValidator == null) {
            return;
        }
        nodeValidator.simpleValidate(node);
    }

    private NodeValidator getNodeValidator(WorkflowNodeInfoDO node) {
        Integer nodeTypeCode = node.getType();
        if (nodeTypeCode == null) {
            return this.nodeValidatorMap.get(WorkflowNodeType.JOB);
        }
        return this.nodeValidatorMap.get(WorkflowNodeType.of((int)nodeTypeCode));
    }
}

