/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.EncryptType;
import tech.powerjob.common.enums.ErrorCodes;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.utils.DigestUtils;
import tech.powerjob.server.common.utils.AESUtil;
import tech.powerjob.server.core.service.AppInfoService;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;

@Service
public class AppInfoServiceImpl
implements AppInfoService {
    private static final Logger log = LoggerFactory.getLogger(AppInfoServiceImpl.class);
    private final Cache<Long, AppInfoDO> appId2AppInfoDO = CacheBuilder.newBuilder().softValues().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(1024L).build();
    private final AppInfoRepository appInfoRepository;
    private static final String ENCRYPT_KEY = "ChinaNo.1_ChinaNo.1_ChinaNo.1AAA";
    private static final String ENCRYPT_PWD_PREFIX = "sys_encrypt_aes:";

    @Override
    public Optional<AppInfoDO> findByAppName(String appName) {
        return this.appInfoRepository.findByAppName(appName);
    }

    @Override
    public Optional<AppInfoDO> findById(Long appId, boolean useCache) {
        if (!useCache) {
            Optional appInfoOpt = this.appInfoRepository.findById((Object)appId);
            appInfoOpt.ifPresent(appInfo -> this.appId2AppInfoDO.put((Object)appId, appInfo));
            return appInfoOpt;
        }
        try {
            AppInfoDO appInfoDO = (AppInfoDO)this.appId2AppInfoDO.get((Object)appId, () -> {
                Optional appInfoOpt = this.appInfoRepository.findById((Object)appId);
                if (appInfoOpt.isPresent()) {
                    return (AppInfoDO)appInfoOpt.get();
                }
                throw new IllegalArgumentException("can't find appInfo by appId:" + appId);
            });
            return Optional.of(appInfoDO);
        }
        catch (Exception e) {
            log.warn("[AppInfoService] findByIdWithCache failed,appId={}", (Object)appId, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void deleteById(Long appId) {
        this.appInfoRepository.deleteById((Object)appId);
    }

    @Override
    public AppInfoDO save(AppInfoDO appInfo) {
        String originPassword = appInfo.getPassword();
        String encryptPassword = AESUtil.encrypt((String)originPassword, (String)ENCRYPT_KEY);
        String finalPassword = ENCRYPT_PWD_PREFIX.concat(encryptPassword);
        appInfo.setPassword(finalPassword);
        return (AppInfoDO)this.appInfoRepository.saveAndFlush((Object)appInfo);
    }

    @Override
    public Long assertApp(String appName, String password, String encryptType) {
        AppInfoDO appInfo = (AppInfoDO)this.appInfoRepository.findByAppName(appName).orElseThrow(() -> new PowerJobException(ErrorCodes.INVALID_APP, appName));
        return this.assertApp(appInfo, password, encryptType);
    }

    @Override
    public Long assertApp(AppInfoDO appInfo, String password, String encryptType) {
        boolean checkPass = this.checkPassword(appInfo, password, encryptType);
        if (!checkPass) {
            throw new PowerJobException(ErrorCodes.INCORRECT_PASSWORD, null);
        }
        return appInfo.getId();
    }

    private boolean checkPassword(AppInfoDO appInfo, String password, String encryptType) {
        String originPwd = this.fetchOriginAppPassword(appInfo);
        if (StringUtils.isEmpty((CharSequence)encryptType) || EncryptType.NONE.getCode().equalsIgnoreCase(encryptType)) {
            return password.equals(originPwd);
        }
        if (EncryptType.MD5.getCode().equalsIgnoreCase(encryptType)) {
            return password.equalsIgnoreCase(DigestUtils.md5((String)originPwd));
        }
        throw new PowerJobException(ErrorCodes.INVALID_REQUEST, "unknown_encryptType:" + encryptType);
    }

    @Override
    public String fetchOriginAppPassword(AppInfoDO appInfo) {
        String dbPwd = appInfo.getPassword();
        if (StringUtils.isEmpty((CharSequence)dbPwd)) {
            return dbPwd;
        }
        if (dbPwd.startsWith(ENCRYPT_PWD_PREFIX)) {
            String encryptPassword = dbPwd.replaceFirst(ENCRYPT_PWD_PREFIX, "");
            return AESUtil.decrypt((String)encryptPassword, (String)ENCRYPT_KEY);
        }
        return dbPwd;
    }

    public AppInfoServiceImpl(AppInfoRepository appInfoRepository) {
        this.appInfoRepository = appInfoRepository;
    }
}

