/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.enums.WorkflowInstanceStatus;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.common.response.WorkflowInstanceInfoDTO;
import tech.powerjob.server.common.utils.SpringUtils;
import tech.powerjob.server.core.instance.InstanceService;
import tech.powerjob.server.core.lock.UseCacheLock;
import tech.powerjob.server.core.workflow.WorkflowInstanceManager;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAGUtils;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowInstanceInfoRepository;
import tech.powerjob.server.remote.server.redirector.DesignateServer;

@Service
public class WorkflowInstanceService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceService.class);
    private final InstanceService instanceService;
    private final WorkflowInstanceInfoRepository wfInstanceInfoRepository;
    private final WorkflowInstanceManager workflowInstanceManager;
    private final WorkflowInfoRepository workflowInfoRepository;

    public void stopWorkflowInstanceEntrance(Long wfInstanceId, Long appId) {
        WorkflowInstanceInfoDO wfInstance = this.fetchWfInstance(wfInstanceId, appId);
        if (!WorkflowInstanceStatus.GENERALIZED_RUNNING_STATUS.contains(wfInstance.getStatus())) {
            throw new PowerJobException("workflow instance already stopped");
        }
        if (wfInstance.getParentWfInstanceId() != null) {
            ((WorkflowInstanceService)SpringUtils.getBean(this.getClass())).stopWorkflowInstance(wfInstance.getParentWfInstanceId(), appId);
            return;
        }
        ((WorkflowInstanceService)SpringUtils.getBean(this.getClass())).stopWorkflowInstance(wfInstanceId, appId);
    }

    @DesignateServer
    @UseCacheLock(type="processWfInstance", key="#wfInstanceId", concurrencyLevel=1024)
    public void stopWorkflowInstance(Long wfInstanceId, Long appId) {
        WorkflowInstanceInfoDO wfInstance = this.fetchWfInstance(wfInstanceId, appId);
        if (!WorkflowInstanceStatus.GENERALIZED_RUNNING_STATUS.contains(wfInstance.getStatus())) {
            throw new PowerJobException("workflow instance already stopped");
        }
        PEWorkflowDAG dag = (PEWorkflowDAG)JSON.parseObject((String)wfInstance.getDag(), PEWorkflowDAG.class);
        dag.getNodes().forEach(node -> {
            try {
                if (node.getInstanceId() != null && InstanceStatus.GENERALIZED_RUNNING_STATUS.contains(node.getStatus())) {
                    log.debug("[WfInstance-{}] instance({}) is running, try to stop it now.", (Object)wfInstanceId, (Object)node.getInstanceId());
                    node.setStatus(Integer.valueOf(InstanceStatus.STOPPED.getV()));
                    node.setResult("stopped by user");
                    if (Objects.equals(node.getNodeType(), WorkflowNodeType.NESTED_WORKFLOW.getCode())) {
                        this.stopWorkflowInstance(node.getInstanceId(), appId);
                    } else {
                        this.instanceService.stopInstance(appId, node.getInstanceId());
                    }
                }
            }
            catch (Exception e) {
                log.warn("[WfInstance-{}] stop instance({}) failed.", new Object[]{wfInstanceId, JSON.toJSONString((Object)node), e});
            }
        });
        wfInstance.setDag(JSON.toJSONString((Object)dag));
        wfInstance.setStatus(Integer.valueOf(WorkflowInstanceStatus.STOPPED.getV()));
        wfInstance.setResult("stopped by user");
        wfInstance.setGmtModified(new Date());
        this.wfInstanceInfoRepository.saveAndFlush((Object)wfInstance);
        log.info("[WfInstance-{}] stop workflow instance successfully~", (Object)wfInstanceId);
    }

    @DesignateServer
    @UseCacheLock(type="processWfInstance", key="#wfInstanceId", concurrencyLevel=1024)
    public void retryWorkflowInstance(Long wfInstanceId, Long appId) {
        PEWorkflowDAG dag;
        WorkflowInstanceInfoDO wfInstance = this.fetchWfInstance(wfInstanceId, appId);
        if (WorkflowInstanceStatus.GENERALIZED_RUNNING_STATUS.contains(wfInstance.getStatus())) {
            throw new PowerJobException("workflow instance is running");
        }
        if (wfInstance.getStatus().intValue() == WorkflowInstanceStatus.SUCCEED.getV()) {
            throw new PowerJobException("workflow instance is already successful");
        }
        if ("can't find some job".equals(wfInstance.getResult())) {
            throw new PowerJobException("you can't retry the workflow instance which is missing job info!");
        }
        try {
            dag = (PEWorkflowDAG)JSON.parseObject((String)wfInstance.getDag(), PEWorkflowDAG.class);
            if (!WorkflowDAGUtils.valid(dag)) {
                throw new PowerJobException("invalid dag");
            }
        }
        catch (Exception e) {
            throw new PowerJobException("you can't retry the workflow instance whose DAG is illegal!");
        }
        Optional workflowInfo = this.workflowInfoRepository.findById((Object)wfInstance.getWorkflowId());
        if (!workflowInfo.isPresent() || ((WorkflowInfoDO)workflowInfo.get()).getStatus().intValue() == SwitchableStatus.DISABLE.getV()) {
            throw new PowerJobException("you can't retry the workflow instance whose metadata is unavailable!");
        }
        WorkflowDAGUtils.resetRetryableNode(dag);
        wfInstance.setDag(JSON.toJSONString((Object)dag));
        wfInstance.setStatus(Integer.valueOf(WorkflowInstanceStatus.WAITING.getV()));
        wfInstance.setGmtModified(new Date());
        this.wfInstanceInfoRepository.saveAndFlush((Object)wfInstance);
        this.workflowInstanceManager.start((WorkflowInfoDO)workflowInfo.get(), wfInstanceId);
    }

    public WorkflowInstanceInfoDTO fetchWorkflowInstanceInfo(Long wfInstanceId, Long appId) {
        WorkflowInstanceInfoDO wfInstance = this.fetchWfInstance(wfInstanceId, appId);
        WorkflowInstanceInfoDTO dto = new WorkflowInstanceInfoDTO();
        BeanUtils.copyProperties((Object)wfInstance, (Object)dto);
        return dto;
    }

    public WorkflowInstanceInfoDO fetchWfInstance(Long wfInstanceId, Long appId) {
        WorkflowInstanceInfoDO wfInstance = (WorkflowInstanceInfoDO)this.wfInstanceInfoRepository.findByWfInstanceId(wfInstanceId).orElseThrow(() -> new IllegalArgumentException("can't find workflow instance by wfInstanceId: " + wfInstanceId));
        if (!Objects.equals(appId, wfInstance.getAppId())) {
            throw new PowerJobException("Permission Denied!");
        }
        return wfInstance;
    }

    @DesignateServer
    @UseCacheLock(type="processWfInstance", key="#wfInstanceId", concurrencyLevel=1024)
    public void markNodeAsSuccess(Long appId, Long wfInstanceId, Long nodeId) {
        boolean allowSkipWhenFailed;
        WorkflowInstanceInfoDO wfInstance = this.fetchWfInstance(wfInstanceId, appId);
        if (WorkflowInstanceStatus.GENERALIZED_RUNNING_STATUS.contains(wfInstance.getStatus())) {
            throw new PowerJobException("you can't mark the node in a running workflow!");
        }
        PEWorkflowDAG dag = (PEWorkflowDAG)JSON.parseObject((String)wfInstance.getDag(), PEWorkflowDAG.class);
        PEWorkflowDAG.Node targetNode = null;
        for (PEWorkflowDAG.Node node : dag.getNodes()) {
            if (!node.getNodeId().equals(nodeId)) continue;
            targetNode = node;
            break;
        }
        if (targetNode == null) {
            throw new PowerJobException("can't find the node in current DAG!");
        }
        boolean bl = allowSkipWhenFailed = targetNode.getSkipWhenFailed() != null && targetNode.getSkipWhenFailed() != false;
        if (targetNode.getInstanceId() != null && targetNode.getStatus().intValue() == InstanceStatus.FAILED.getV() && !allowSkipWhenFailed) {
            targetNode.setStatus(Integer.valueOf(InstanceStatus.SUCCEED.getV())).setResult("mark as successful node");
            wfInstance.setDag(JSON.toJSONString((Object)dag));
            this.wfInstanceInfoRepository.saveAndFlush((Object)wfInstance);
            return;
        }
        throw new PowerJobException("you can only mark the node which is failed and not allow to skip!");
    }

    public WorkflowInstanceService(InstanceService instanceService, WorkflowInstanceInfoRepository wfInstanceInfoRepository, WorkflowInstanceManager workflowInstanceManager, WorkflowInfoRepository workflowInfoRepository) {
        this.instanceService = instanceService;
        this.wfInstanceInfoRepository = wfInstanceInfoRepository;
        this.workflowInstanceManager = workflowInstanceManager;
        this.workflowInfoRepository = workflowInfoRepository;
    }
}

