/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow.hanlder.impl;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.enums.WorkflowInstanceStatus;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.common.utils.SpringUtils;
import tech.powerjob.server.core.workflow.WorkflowInstanceManager;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAGUtils;
import tech.powerjob.server.core.workflow.hanlder.TaskNodeHandler;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowInstanceInfoRepository;

@Component
public class NestedWorkflowNodeHandler
implements TaskNodeHandler {
    private static final Logger log = LoggerFactory.getLogger(NestedWorkflowNodeHandler.class);
    private final WorkflowInfoRepository workflowInfoRepository;
    private final WorkflowInstanceInfoRepository workflowInstanceInfoRepository;

    @Override
    public void createTaskInstance(PEWorkflowDAG.Node node, PEWorkflowDAG dag, WorkflowInstanceInfoDO wfInstanceInfo) {
        Long wfId = node.getJobId();
        WorkflowInfoDO targetWf = this.workflowInfoRepository.findById((Object)wfId).orElse(null);
        if (targetWf == null || targetWf.getStatus().intValue() == SwitchableStatus.DELETED.getV()) {
            if (targetWf == null) {
                log.error("[Workflow-{}|{}] invalid nested workflow node({}),target workflow({}) is not exist!", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), node.getJobId()});
            } else {
                log.error("[Workflow-{}|{}] invalid nested workflow node({}),target workflow({}) has been deleted!", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), node.getJobId()});
            }
            throw new PowerJobException("invalid nested workflow node," + node.getNodeId());
        }
        if (node.getInstanceId() != null) {
            WorkflowInstanceInfoDO wfInstance = this.workflowInstanceInfoRepository.findByWfInstanceId(node.getInstanceId()).orElse(null);
            if (wfInstance == null) {
                log.error("[Workflow-{}|{}] invalid nested workflow node({}),target workflow instance({}) is not exist!", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), node.getInstanceId()});
                throw new PowerJobException("invalid nested workflow instance id " + node.getInstanceId());
            }
            try {
                PEWorkflowDAG nodeDag = (PEWorkflowDAG)JSON.parseObject((String)wfInstance.getDag(), PEWorkflowDAG.class);
                if (!WorkflowDAGUtils.valid(nodeDag)) {
                    throw new PowerJobException("invalid dag");
                }
                WorkflowDAGUtils.resetRetryableNode(nodeDag);
                wfInstance.setDag(JSON.toJSONString((Object)nodeDag));
                wfInstance.setStatus(Integer.valueOf(WorkflowInstanceStatus.WAITING.getV()));
                wfInstance.setGmtModified(new Date());
                this.workflowInstanceInfoRepository.saveAndFlush((Object)wfInstance);
            }
            catch (Exception e) {
                log.error("[Workflow-{}|{}] invalid nested workflow node({}),target workflow instance({})'s DAG is illegal!", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), node.getNodeId(), node.getInstanceId(), e});
                throw new PowerJobException("illegal nested workflow instance, id : " + node.getInstanceId());
            }
        } else {
            String wfContext = wfInstanceInfo.getWfContext();
            Long instanceId = ((WorkflowInstanceManager)SpringUtils.getBean(WorkflowInstanceManager.class)).create(targetWf, wfContext, System.currentTimeMillis(), wfInstanceInfo.getWfInstanceId());
            node.setInstanceId(instanceId);
        }
        node.setStartTime(CommonUtils.formatTime((Long)System.currentTimeMillis()));
        node.setStatus(Integer.valueOf(InstanceStatus.RUNNING.getV()));
    }

    @Override
    public void startTaskInstance(PEWorkflowDAG.Node node) {
        Long wfId = node.getJobId();
        WorkflowInfoDO targetWf = this.workflowInfoRepository.findById((Object)wfId).orElse(null);
        ((WorkflowInstanceManager)SpringUtils.getBean(WorkflowInstanceManager.class)).start(targetWf, node.getInstanceId());
    }

    @Override
    public WorkflowNodeType matchingType() {
        return WorkflowNodeType.NESTED_WORKFLOW;
    }

    public NestedWorkflowNodeHandler(WorkflowInfoRepository workflowInfoRepository, WorkflowInstanceInfoRepository workflowInstanceInfoRepository) {
        this.workflowInfoRepository = workflowInfoRepository;
        this.workflowInstanceInfoRepository = workflowInstanceInfoRepository;
    }
}

