/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.mongodb;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class GridFsManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GridFsManager.class);
    private final Environment environment;
    private final MongoDatabase db;
    private boolean available;
    private final Map<String, GridFSBucket> bucketCache = Maps.newConcurrentMap();
    public static final String LOG_BUCKET = "log";
    public static final String CONTAINER_BUCKET = "container";

    public GridFsManager(Environment environment, @Autowired(required=false) MongoTemplate mongoTemplate) {
        this.environment = environment;
        this.db = mongoTemplate != null ? mongoTemplate.getDb() : null;
    }

    public boolean available() {
        return this.available;
    }

    public void store(File localFile, String bucketName, String fileName) throws IOException {
        if (this.available()) {
            GridFSBucket bucket = this.getBucket(bucketName);
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(localFile));){
                bucket.uploadFromStream(fileName, (InputStream)bis);
            }
        }
    }

    public void download(File targetFile, String bucketName, String fileName) throws IOException {
        if (this.available()) {
            GridFSBucket bucket = this.getBucket(bucketName);
            try (GridFSDownloadStream gis = bucket.openDownloadStream(fileName);
                 BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(targetFile));){
                byte[] buffer = new byte[1024];
                int bytes = 0;
                while ((bytes = gis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytes);
                }
                bos.flush();
            }
        }
    }

    public void deleteBefore(String bucketName, int day) {
        Stopwatch sw = Stopwatch.createStarted();
        Date date = DateUtils.addDays((Date)new Date(), (int)(-day));
        GridFSBucket bucket = this.getBucket(bucketName);
        Bson filter = Filters.lt((String)"uploadDate", (Object)date);
        bucket.find(filter).forEach(gridFSFile -> {
            ObjectId objectId = gridFSFile.getObjectId();
            try {
                bucket.delete(objectId);
                log.info("[GridFsManager] deleted {}#{}", (Object)bucketName, (Object)objectId);
            }
            catch (Exception e) {
                log.error("[GridFsManager] deleted {}#{} failed.", new Object[]{bucketName, objectId, e});
            }
        });
        log.info("[GridFsManager] clean bucket({}) successfully, delete all files before {}, using {}.", new Object[]{bucketName, date, sw.stop()});
    }

    public boolean exists(String bucketName, String fileName) {
        GridFSBucket bucket = this.getBucket(bucketName);
        GridFSFindIterable files = bucket.find(Filters.eq((String)"filename", (Object)fileName));
        try {
            GridFSFile first = (GridFSFile)files.first();
            return first != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private GridFSBucket getBucket(String bucketName) {
        return this.bucketCache.computeIfAbsent(bucketName, ignore -> GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName));
    }

    public void afterPropertiesSet() throws Exception {
        String enable = this.environment.getProperty("oms.mongodb.enable", Boolean.FALSE.toString());
        this.available = Boolean.TRUE.toString().equals(enable) && this.db != null;
        log.info("[GridFsManager] available: {}, db: {}", (Object)this.available, (Object)this.db);
    }
}

