/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.server;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.remote.framework.actor.Handler;
import tech.powerjob.remote.framework.actor.ProcessType;
import tech.powerjob.server.remote.aware.TransportServiceAware;
import tech.powerjob.server.remote.server.election.Ping;
import tech.powerjob.server.remote.server.redirector.RemoteProcessReq;
import tech.powerjob.server.remote.server.redirector.RemoteRequestProcessor;
import tech.powerjob.server.remote.transporter.TransportService;

@Component
@Actor(path="friend")
public class FriendActor
implements TransportServiceAware {
    private static final Logger log = LoggerFactory.getLogger(FriendActor.class);
    private TransportService transportService;

    @Handler(path="ping", processType=ProcessType.NO_BLOCKING)
    public AskResponse onReceivePing(Ping ping) {
        return AskResponse.succeed(this.transportService.allProtocols());
    }

    @Handler(path="process", processType=ProcessType.BLOCKING)
    public AskResponse onReceiveRemoteProcessReq(RemoteProcessReq req) {
        AskResponse response = new AskResponse();
        response.setSuccess(true);
        try {
            response.setData(JsonUtils.toBytes((Object)RemoteRequestProcessor.processRemoteRequest(req)));
        }
        catch (Throwable t) {
            log.error("[FriendActor] process remote request[{}] failed!", (Object)req, (Object)t);
            response.setSuccess(false);
            response.setMessage(ExceptionUtils.getMessage((Throwable)t));
        }
        return response;
    }

    @Override
    public void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }
}

