/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.transporter.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.remote.framework.actor.Actor;
import tech.powerjob.remote.framework.base.Address;
import tech.powerjob.remote.framework.base.RemotingException;
import tech.powerjob.remote.framework.base.ServerType;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.remote.framework.engine.EngineConfig;
import tech.powerjob.remote.framework.engine.EngineOutput;
import tech.powerjob.remote.framework.engine.RemoteEngine;
import tech.powerjob.remote.framework.engine.impl.PowerJobRemoteEngine;
import tech.powerjob.server.remote.transporter.ProtocolInfo;
import tech.powerjob.server.remote.transporter.TransportService;

@Service
public class PowerTransportService
implements TransportService,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PowerTransportService.class);
    @Value(value="${oms.transporter.active.protocols}")
    private String activeProtocols;
    @Value(value="${oms.transporter.main.protocol}")
    private String mainProtocol;
    private static final String PROTOCOL_PORT_CONFIG = "oms.%s.port";
    private final Environment environment;
    private ProtocolInfo defaultProtocol;
    private final Map<String, ProtocolInfo> protocolName2Info = Maps.newHashMap();
    private final List<RemoteEngine> engines = Lists.newArrayList();
    private ApplicationContext applicationContext;

    public PowerTransportService(Environment environment) {
        this.environment = environment;
    }

    @Override
    public ProtocolInfo defaultProtocol() {
        return this.defaultProtocol;
    }

    @Override
    public Map<String, ProtocolInfo> allProtocols() {
        return this.protocolName2Info;
    }

    private ProtocolInfo fetchProtocolInfo(String protocol) {
        ProtocolInfo protocolInfo = this.protocolName2Info.get(protocol = this.compatibleProtocol(protocol));
        if (protocolInfo == null) {
            throw new IllegalArgumentException("can't find Transporter by protocol :" + protocol);
        }
        return protocolInfo;
    }

    @Override
    public void tell(String protocol, URL url, PowerSerializable request) {
        this.fetchProtocolInfo(protocol).getTransporter().tell(url, request);
    }

    @Override
    public <T> CompletionStage<T> ask(String protocol, URL url, PowerSerializable request, Class<T> clz) throws RemotingException {
        return this.fetchProtocolInfo(protocol).getTransporter().ask(url, request, clz);
    }

    private void initRemoteFrameWork(String protocol, int port) {
        Map beansWithAnnotation = this.applicationContext.getBeansWithAnnotation(Actor.class);
        log.info("[PowerTransportService] find Actor num={},names={}", (Object)beansWithAnnotation.size(), beansWithAnnotation.keySet());
        Address address = new Address().setHost(NetUtils.getLocalHost()).setPort(port);
        EngineConfig engineConfig = new EngineConfig().setServerType(ServerType.SERVER).setType(protocol.toUpperCase()).setBindAddress(address).setActorList((List)Lists.newArrayList(beansWithAnnotation.values()));
        log.info("[PowerTransportService] start to initialize RemoteEngine[type={},address={}]", (Object)protocol, (Object)address);
        PowerJobRemoteEngine re = new PowerJobRemoteEngine();
        EngineOutput engineOutput = re.start(engineConfig);
        log.info("[PowerTransportService] start RemoteEngine[type={},address={}] successfully", (Object)protocol, (Object)address);
        this.engines.add((RemoteEngine)re);
        this.protocolName2Info.put(protocol, new ProtocolInfo(protocol, address.toFullAddress(), engineOutput.getTransporter()));
    }

    public void afterPropertiesSet() throws Exception {
        log.info("[PowerTransportService] start to initialize whole PowerTransportService!");
        log.info("[PowerTransportService] activeProtocols: {}", (Object)this.activeProtocols);
        if (StringUtils.isEmpty((CharSequence)this.activeProtocols)) {
            throw new IllegalArgumentException("activeProtocols can't be empty!");
        }
        for (String protocol : this.activeProtocols.split(",")) {
            try {
                int port = this.parseProtocolPort(protocol);
                this.initRemoteFrameWork(protocol, port);
            }
            catch (Throwable t) {
                log.error("[PowerTransportService] initialize protocol[{}] failed. If you don't need to use this protocol, you can turn it off by 'oms.transporter.active.protocols'", (Object)protocol);
                ExceptionUtils.rethrow((Throwable)t);
            }
        }
        this.choseDefault();
        log.info("[PowerTransportService] initialize successfully!");
        log.info("[PowerTransportService] ALL_PROTOCOLS: {}", this.protocolName2Info);
    }

    private int parseProtocolPort(String protocol) {
        String key1 = String.format(PROTOCOL_PORT_CONFIG, protocol.toLowerCase());
        String key2 = String.format(PROTOCOL_PORT_CONFIG, protocol.toUpperCase());
        String portStr = this.environment.getProperty(key1);
        if (StringUtils.isEmpty((CharSequence)portStr)) {
            portStr = this.environment.getProperty(key2);
        }
        log.info("[PowerTransportService] fetch port for protocol[{}], key={}, value={}", new Object[]{protocol, key1, portStr});
        if (StringUtils.isEmpty((CharSequence)portStr)) {
            throw new IllegalArgumentException(String.format("can't find protocol config by key: %s, please check your spring config!", key1));
        }
        return Integer.parseInt(portStr);
    }

    private String compatibleProtocol(String p) {
        if (p == null) {
            return Protocol.AKKA.name();
        }
        return p;
    }

    private void choseDefault() {
        this.defaultProtocol = this.protocolName2Info.get(this.mainProtocol);
        log.info("[PowerTransportService] chose [{}] as the default protocol, make sure this protocol can work!", (Object)this.mainProtocol);
        if (this.defaultProtocol == null) {
            throw new IllegalArgumentException("can't find default protocol, please check your config!");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        this.engines.forEach(e -> {
            try {
                e.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

