/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.server.election;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.request.ServerDiscoveryRequest;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.server.extension.LockService;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.remote.server.election.Ping;
import tech.powerjob.server.remote.transporter.ProtocolInfo;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.transporter.impl.ServerURLFactory;

@Service
public class ServerElectionService {
    private static final Logger log = LoggerFactory.getLogger(ServerElectionService.class);
    private final LockService lockService;
    private final TransportService transportService;
    private final AppInfoRepository appInfoRepository;
    private final int accurateSelectServerPercentage;
    private static final int RETRY_TIMES = 10;
    private static final long PING_TIMEOUT_MS = 1000L;
    private static final String SERVER_ELECT_LOCK = "server_elect_%d";

    public ServerElectionService(LockService lockService, TransportService transportService, AppInfoRepository appInfoRepository, @Value(value="${oms.accurate.select.server.percentage}") int accurateSelectServerPercentage) {
        this.lockService = lockService;
        this.transportService = transportService;
        this.appInfoRepository = appInfoRepository;
        this.accurateSelectServerPercentage = accurateSelectServerPercentage;
    }

    public String elect(ServerDiscoveryRequest request) {
        if (!this.accurate()) {
            String currentServer = request.getCurrentServer();
            Optional<ProtocolInfo> localProtocolInfoOpt = Optional.ofNullable(this.transportService.allProtocols().get(request.getProtocol()));
            if (localProtocolInfoOpt.isPresent() && (localProtocolInfoOpt.get().getExternalAddress().equals(currentServer) || localProtocolInfoOpt.get().getAddress().equals(currentServer))) {
                log.info("[ServerElection] this server[{}] is worker[appId={}]'s current server, skip check", (Object)currentServer, (Object)request.getAppId());
                return currentServer;
            }
        }
        return this.getServer0(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServer0(ServerDiscoveryRequest discoveryRequest) {
        Long appId = discoveryRequest.getAppId();
        String protocol = discoveryRequest.getProtocol();
        HashSet downServerCache = Sets.newHashSet();
        for (int i = 0; i < 10; ++i) {
            Optional appInfoOpt = this.appInfoRepository.findById((Object)appId);
            if (!appInfoOpt.isPresent()) {
                throw new PowerJobException(appId + " is not registered!");
            }
            String appName = ((AppInfoDO)appInfoOpt.get()).getAppName();
            String originServer = ((AppInfoDO)appInfoOpt.get()).getCurrentServer();
            String activeAddress = this.activeAddress(originServer, downServerCache, protocol);
            if (StringUtils.isNotEmpty((CharSequence)activeAddress)) {
                return activeAddress;
            }
            String lockName = String.format(SERVER_ELECT_LOCK, appId);
            boolean lockStatus = this.lockService.tryLock(lockName, 30000L);
            if (!lockStatus) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                AppInfoDO appInfo = (AppInfoDO)this.appInfoRepository.findById((Object)appId).orElseThrow(() -> new RuntimeException("impossible, unless we just lost our database."));
                String address = this.activeAddress(appInfo.getCurrentServer(), downServerCache, protocol);
                if (StringUtils.isNotEmpty((CharSequence)address)) {
                    String string = address;
                    return string;
                }
                ProtocolInfo targetProtocolInfo = this.transportService.allProtocols().get(protocol);
                if (targetProtocolInfo == null) continue;
                appInfo.setCurrentServer(this.transportService.defaultProtocol().getAddress());
                appInfo.setGmtModified(new Date());
                this.appInfoRepository.saveAndFlush((Object)appInfo);
                log.info("[ServerElection] this server({}) become the new server for app(appId={}).", (Object)appInfo.getCurrentServer(), (Object)appId);
                String string = targetProtocolInfo.getExternalAddress();
                return string;
            }
            catch (Exception e) {
                log.error("[ServerElection] write new server to db failed for app {}.", (Object)appName, (Object)e);
                continue;
            }
            finally {
                this.lockService.unlock(lockName);
            }
        }
        throw new PowerJobException("server elect failed for app " + appId);
    }

    private String activeAddress(String serverAddress, Set<String> downServerCache, String protocol) {
        if (downServerCache.contains(serverAddress)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)serverAddress)) {
            return null;
        }
        Ping ping = new Ping();
        ping.setCurrentTime(System.currentTimeMillis());
        URL targetUrl = ServerURLFactory.ping2Friend(serverAddress);
        try {
            AskResponse response = this.transportService.ask(Protocol.HTTP.name(), targetUrl, ping, AskResponse.class).toCompletableFuture().get(1000L, TimeUnit.MILLISECONDS);
            if (response.isSuccess()) {
                JSONObject protocolInfo = ((JSONObject)JsonUtils.parseObject((byte[])response.getData(), JSONObject.class)).getJSONObject(protocol);
                if (protocolInfo != null) {
                    downServerCache.remove(serverAddress);
                    ProtocolInfo remoteProtocol = (ProtocolInfo)protocolInfo.toJavaObject(ProtocolInfo.class);
                    log.info("[ServerElection] server[{}] is active, it will be the master, final protocol={}", (Object)serverAddress, (Object)remoteProtocol);
                    return Optional.ofNullable(remoteProtocol.getExternalAddress()).orElse(remoteProtocol.getAddress());
                }
                log.warn("[ServerElection] server[{}] is active but don't have target protocol", (Object)serverAddress);
            }
        }
        catch (TimeoutException te) {
            log.warn("[ServerElection] server[{}] was down due to ping timeout!", (Object)serverAddress);
        }
        catch (Exception e) {
            log.warn("[ServerElection] server[{}] was down with unknown case!", (Object)serverAddress, (Object)e);
        }
        downServerCache.add(serverAddress);
        return null;
    }

    private boolean accurate() {
        return ThreadLocalRandom.current().nextInt(100) < this.accurateSelectServerPercentage;
    }
}

