/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.worker.filter;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.server.common.SJ;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.remote.worker.filter.WorkerFilter;

@Component
public class DesignatedWorkerFilter
implements WorkerFilter {
    private static final Logger log = LoggerFactory.getLogger(DesignatedWorkerFilter.class);

    @Override
    public boolean filter(WorkerInfo workerInfo, JobInfoDO jobInfo) {
        String designatedWorkers = jobInfo.getDesignatedWorkers();
        if (StringUtils.isEmpty((CharSequence)designatedWorkers)) {
            return false;
        }
        HashSet designatedWorkersSet = Sets.newHashSet((Iterable)SJ.COMMA_SPLITTER.splitToList((CharSequence)designatedWorkers));
        for (String tagOrAddress : designatedWorkersSet) {
            if (!tagOrAddress.equals(workerInfo.getTag()) && !tagOrAddress.equals(workerInfo.getAddress())) continue;
            return false;
        }
        return true;
    }
}

