/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.worker.selector.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.DispatchStrategy;
import tech.powerjob.common.utils.CollectionUtils;
import tech.powerjob.server.common.module.WorkerInfo;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.remote.worker.selector.TaskTrackerSelector;
import tech.powerjob.server.remote.worker.utils.SpecifyUtils;

@Component
public class SpecifyTaskTrackerSelector
implements TaskTrackerSelector {
    private static final Logger log = LoggerFactory.getLogger(SpecifyTaskTrackerSelector.class);

    @Override
    public DispatchStrategy strategy() {
        return DispatchStrategy.SPECIFY;
    }

    @Override
    public WorkerInfo select(JobInfoDO jobInfoDO, InstanceInfoDO instanceInfoDO, List<WorkerInfo> availableWorkers) {
        String dispatchStrategyConfig = jobInfoDO.getDispatchStrategyConfig();
        if (StringUtils.isEmpty((CharSequence)dispatchStrategyConfig)) {
            log.warn("[SpecifyTaskTrackerSelector] job[id={}]'s dispatchStrategyConfig is empty, use random as bottom DispatchStrategy!", (Object)jobInfoDO.getId());
            return availableWorkers.get(ThreadLocalRandom.current().nextInt(availableWorkers.size()));
        }
        ArrayList targetWorkers = Lists.newArrayList();
        availableWorkers.forEach(aw -> {
            boolean match = SpecifyUtils.match(aw, dispatchStrategyConfig);
            if (match) {
                targetWorkers.add(aw);
            }
        });
        if (CollectionUtils.isEmpty((Collection)targetWorkers)) {
            log.warn("[SpecifyTaskTrackerSelector] Unable to find available nodes based on conditions for job(id={},dispatchStrategyConfig={}), use random as bottom DispatchStrategy!", (Object)jobInfoDO.getId(), (Object)dispatchStrategyConfig);
            return availableWorkers.get(ThreadLocalRandom.current().nextInt(availableWorkers.size()));
        }
        return (WorkerInfo)targetWorkers.get(ThreadLocalRandom.current().nextInt(targetWorkers.size()));
    }
}

