/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.server.core.service.AppInfoService;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.web.request.AppAssertRequest;
import tech.powerjob.server.web.request.ModifyAppInfoRequest;

@RestController
@RequestMapping(value={"/appInfo"})
public class AppInfoController {
    private final AppInfoService appInfoService;
    private final AppInfoRepository appInfoRepository;
    private static final int MAX_APP_NUM = 200;

    @PostMapping(value={"/save"})
    public ResultDTO<Void> saveAppInfo(@RequestBody ModifyAppInfoRequest req) {
        AppInfoDO appInfoDO;
        req.valid();
        Long id = req.getId();
        if (id == null) {
            appInfoDO = new AppInfoDO();
            appInfoDO.setGmtCreate(new Date());
        } else {
            appInfoDO = (AppInfoDO)this.appInfoRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("can't find appInfo by id:" + id));
            if (!Objects.equals(req.getOldPassword(), appInfoDO.getPassword())) {
                throw new PowerJobException("The password is incorrect.");
            }
        }
        BeanUtils.copyProperties((Object)req, (Object)appInfoDO);
        appInfoDO.setGmtModified(new Date());
        this.appInfoRepository.saveAndFlush((Object)appInfoDO);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/assert"})
    public ResultDTO<Long> assertApp(@RequestBody AppAssertRequest request) {
        return ResultDTO.success((Object)this.appInfoService.assertApp(request.getAppName(), request.getPassword()));
    }

    @GetMapping(value={"/delete"})
    public ResultDTO<Void> deleteAppInfo(Long appId) {
        this.appInfoRepository.deleteById((Object)appId);
        return ResultDTO.success(null);
    }

    @GetMapping(value={"/list"})
    public ResultDTO<List<AppInfoVO>> listAppInfo(@RequestParam(required=false) String condition) {
        PageRequest limit = PageRequest.of((int)0, (int)200);
        List result = StringUtils.isEmpty((CharSequence)condition) ? this.appInfoRepository.findAll((Pageable)limit).getContent() : this.appInfoRepository.findByAppNameLike("%" + condition + "%", (Pageable)limit).getContent();
        return ResultDTO.success(AppInfoController.convert(result));
    }

    private static List<AppInfoVO> convert(List<AppInfoDO> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newLinkedList();
        }
        return data.stream().map(appInfoDO -> {
            AppInfoVO appInfoVO = new AppInfoVO();
            BeanUtils.copyProperties((Object)appInfoDO, (Object)appInfoVO);
            return appInfoVO;
        }).collect(Collectors.toList());
    }

    public AppInfoController(AppInfoService appInfoService, AppInfoRepository appInfoRepository) {
        this.appInfoService = appInfoService;
        this.appInfoRepository = appInfoRepository;
    }

    private static class AppInfoVO {
        private Long id;
        private String appName;

        public Long getId() {
            return this.id;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppInfoVO)) {
                return false;
            }
            AppInfoVO other = (AppInfoVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            return !(this$appName == null ? other$appName != null : !this$appName.equals(other$appName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppInfoVO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            return result;
        }

        public String toString() {
            return "AppInfoController.AppInfoVO(id=" + this.getId() + ", appName=" + this.getAppName() + ")";
        }
    }
}

