/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.autoconfigure;

import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.common.utils.NetUtils;
import tech.powerjob.worker.PowerJobWorker;
import tech.powerjob.worker.autoconfigure.PowerJobProperties;
import tech.powerjob.worker.common.PowerJobWorkerConfig;

@Configuration
@EnableConfigurationProperties(value={PowerJobProperties.class})
@Conditional(value={PowerJobWorkerCondition.class})
public class PowerJobAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PowerJobWorker initPowerJob(PowerJobProperties properties) {
        PowerJobProperties.Worker worker = properties.getWorker();
        CommonUtils.requireNonNull((Object)worker.getServerAddress(), (String)"serverAddress can't be empty!");
        List<String> serverAddress = Arrays.asList(worker.getServerAddress().split(","));
        PowerJobWorkerConfig config = new PowerJobWorkerConfig();
        int port = worker.getAkkaPort();
        if (port <= 0) {
            port = NetUtils.getRandomPort();
        }
        config.setPort(port);
        config.setAppName(worker.getAppName());
        config.setServerAddress(serverAddress);
        config.setStoreStrategy(worker.getStoreStrategy());
        config.setEnableTestMode(worker.isEnableTestMode());
        config.setMaxAppendedWfContextLength(worker.getMaxAppendedWfContextLength());
        PowerJobWorker ohMyWorker = new PowerJobWorker();
        ohMyWorker.setConfig(config);
        return ohMyWorker;
    }

    static class PowerJobWorkerCondition
    extends AnyNestedCondition {
        public PowerJobWorkerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="powerjob.worker", name={"server-address"})
        static class PowerJobWorkerProperty {
            PowerJobWorkerProperty() {
            }
        }

        @Deprecated
        @ConditionalOnProperty(prefix="powerjob", name={"server-address"})
        static class PowerJobProperty {
            PowerJobProperty() {
            }
        }
    }
}

