/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import tech.powerjob.worker.common.constants.StoreStrategy;

@ConfigurationProperties(prefix="powerjob")
public class PowerJobProperties {
    private final Worker worker = new Worker();

    public Worker getWorker() {
        return this.worker;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.app-name")
    public String getAppName() {
        return this.getWorker().appName;
    }

    @Deprecated
    public void setAppName(String appName) {
        this.getWorker().setAppName(appName);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.akka-port")
    public int getAkkaPort() {
        return this.getWorker().akkaPort;
    }

    @Deprecated
    public void setAkkaPort(int akkaPort) {
        this.getWorker().setAkkaPort(akkaPort);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.server-address")
    public String getServerAddress() {
        return this.getWorker().serverAddress;
    }

    @Deprecated
    public void setServerAddress(String serverAddress) {
        this.getWorker().setServerAddress(serverAddress);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.store-strategy")
    public StoreStrategy getStoreStrategy() {
        return this.getWorker().storeStrategy;
    }

    @Deprecated
    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.getWorker().setStoreStrategy(storeStrategy);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.max-result-length")
    public int getMaxResultLength() {
        return this.getWorker().maxResultLength;
    }

    @Deprecated
    public void setMaxResultLength(int maxResultLength) {
        this.getWorker().setMaxResultLength(maxResultLength);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.enable-test-mode")
    public boolean isEnableTestMode() {
        return this.getWorker().enableTestMode;
    }

    @Deprecated
    public void setEnableTestMode(boolean enableTestMode) {
        this.getWorker().setEnableTestMode(enableTestMode);
    }

    public static class Worker {
        private String appName;
        private int akkaPort = 27777;
        private String serverAddress;
        private StoreStrategy storeStrategy = StoreStrategy.DISK;
        private int maxResultLength = 8192;
        private boolean enableTestMode = false;
        private int maxAppendedWfContextLength = 8192;

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setAkkaPort(int akkaPort) {
            this.akkaPort = akkaPort;
        }

        public void setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
        }

        public void setStoreStrategy(StoreStrategy storeStrategy) {
            this.storeStrategy = storeStrategy;
        }

        public void setMaxResultLength(int maxResultLength) {
            this.maxResultLength = maxResultLength;
        }

        public void setEnableTestMode(boolean enableTestMode) {
            this.enableTestMode = enableTestMode;
        }

        public void setMaxAppendedWfContextLength(int maxAppendedWfContextLength) {
            this.maxAppendedWfContextLength = maxAppendedWfContextLength;
        }

        public String getAppName() {
            return this.appName;
        }

        public int getAkkaPort() {
            return this.akkaPort;
        }

        public String getServerAddress() {
            return this.serverAddress;
        }

        public StoreStrategy getStoreStrategy() {
            return this.storeStrategy;
        }

        public int getMaxResultLength() {
            return this.maxResultLength;
        }

        public boolean isEnableTestMode() {
            return this.enableTestMode;
        }

        public int getMaxAppendedWfContextLength() {
            return this.maxAppendedWfContextLength;
        }
    }
}

