/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.common.utils;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.math.RoundingMode;
import java.text.NumberFormat;
import tech.powerjob.common.model.SystemMetrics;

public class SystemInfoUtils {
    private static final NumberFormat NF = NumberFormat.getNumberInstance();
    private static final Runtime runtime;
    private static final OperatingSystemMXBean osMXBean;

    public static SystemMetrics getSystemMetrics() {
        SystemMetrics metrics = new SystemMetrics();
        SystemInfoUtils.fillCPUInfo(metrics);
        SystemInfoUtils.fillMemoryInfo(metrics);
        SystemInfoUtils.fillDiskInfo(metrics);
        metrics.calculateScore();
        return metrics;
    }

    private static void fillCPUInfo(SystemMetrics metrics) {
        metrics.setCpuProcessors(osMXBean.getAvailableProcessors());
        metrics.setCpuLoad(SystemInfoUtils.miniDouble(osMXBean.getSystemLoadAverage()));
    }

    private static void fillMemoryInfo(SystemMetrics metrics) {
        long maxMemory = runtime.maxMemory();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        metrics.setJvmMaxMemory(SystemInfoUtils.bytes2GB(maxMemory));
        metrics.setJvmUsedMemory(SystemInfoUtils.bytes2GB(usedMemory));
        metrics.setJvmMemoryUsage(SystemInfoUtils.miniDouble((double)usedMemory / (double)maxMemory));
    }

    private static void fillDiskInfo(SystemMetrics metrics) {
        File[] roots;
        long free = 0L;
        long total = 0L;
        for (File file : roots = File.listRoots()) {
            free += file.getFreeSpace();
            total += file.getTotalSpace();
        }
        metrics.setDiskUsed(SystemInfoUtils.bytes2GB(total - free));
        metrics.setDiskTotal(SystemInfoUtils.bytes2GB(total));
        metrics.setDiskUsage(SystemInfoUtils.miniDouble(metrics.getDiskUsed() / metrics.getDiskTotal()));
    }

    private static double bytes2GB(long bytes) {
        return SystemInfoUtils.miniDouble((double)bytes / 1024.0 / 1024.0 / 1024.0);
    }

    private static double miniDouble(double origin) {
        return Double.parseDouble(NF.format(origin));
    }

    static {
        NF.setMaximumFractionDigits(4);
        NF.setMinimumFractionDigits(4);
        NF.setRoundingMode(RoundingMode.HALF_UP);
        NF.setGroupingUsed(false);
        runtime = Runtime.getRuntime();
        osMXBean = ManagementFactory.getOperatingSystemMXBean();
    }
}

