/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.pojo.request;

import com.google.common.collect.Lists;
import java.util.List;
import tech.powerjob.common.PowerSerializable;
import tech.powerjob.common.serialize.SerializerUtils;
import tech.powerjob.worker.common.ThreadLocalStore;
import tech.powerjob.worker.persistence.TaskDO;

public class ProcessorMapTaskRequest
implements PowerSerializable {
    private Long instanceId;
    private Long subInstanceId;
    private String taskName;
    private List<SubTask> subTasks;

    public ProcessorMapTaskRequest(TaskDO parentTask, List<?> subTaskList, String taskName) {
        this.instanceId = parentTask.getInstanceId();
        this.subInstanceId = parentTask.getSubInstanceId();
        this.taskName = taskName;
        this.subTasks = Lists.newLinkedList();
        subTaskList.forEach(subTask -> {
            String subTaskId = parentTask.getTaskId() + "." + ThreadLocalStore.getTaskIDAddr().getAndIncrement();
            this.subTasks.add(new SubTask(subTaskId, SerializerUtils.serialize((Object)subTask)));
        });
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getSubInstanceId() {
        return this.subInstanceId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public List<SubTask> getSubTasks() {
        return this.subTasks;
    }

    public ProcessorMapTaskRequest() {
    }

    public static class SubTask {
        private String taskId;
        private byte[] taskContent;

        public String getTaskId() {
            return this.taskId;
        }

        public byte[] getTaskContent() {
            return this.taskContent;
        }

        public SubTask() {
        }

        public SubTask(String taskId, byte[] taskContent) {
            this.taskId = taskId;
            this.taskContent = taskContent;
        }
    }
}

