/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.viewstate;

import com.arellomobile.mvp.compiler.ElementProcessor;
import com.arellomobile.mvp.compiler.MvpCompiler;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.compiler.viewstate.ViewInterfaceInfo;
import com.arellomobile.mvp.compiler.viewstate.ViewMethod;
import com.arellomobile.mvp.viewstate.strategy.AddToEndStrategy;
import com.arellomobile.mvp.viewstate.strategy.StateStrategyType;
import com.squareup.javapoet.ParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class ViewInterfaceProcessor
extends ElementProcessor<TypeElement, ViewInterfaceInfo> {
    private static final String STATE_STRATEGY_TYPE_ANNOTATION = StateStrategyType.class.getName();
    private static final TypeElement DEFAULT_STATE_STRATEGY = MvpCompiler.getElementUtils().getTypeElement(AddToEndStrategy.class.getCanonicalName());
    private TypeElement viewInterfaceElement;
    private String viewInterfaceName;
    private Set<TypeElement> usedStrategies = new HashSet<TypeElement>();

    public List<TypeElement> getUsedStrategies() {
        return new ArrayList<TypeElement>(this.usedStrategies);
    }

    @Override
    public ViewInterfaceInfo process(TypeElement element) {
        this.viewInterfaceElement = element;
        this.viewInterfaceName = element.getSimpleName().toString();
        ArrayList<ViewMethod> methods = new ArrayList<ViewMethod>();
        TypeElement interfaceStateStrategyType = this.getInterfaceStateStrategyType(element);
        this.getMethods(element, interfaceStateStrategyType, new ArrayList<ViewMethod>(), methods);
        methods.addAll(this.iterateInterfaces(0, element, interfaceStateStrategyType, methods, new ArrayList<ViewMethod>()));
        HashMap<String, Integer> methodsCounter = new HashMap<String, Integer>();
        for (ViewMethod method : methods) {
            Integer counter = (Integer)methodsCounter.get(method.getName());
            if (counter != null && counter > 0) {
                method.setUniqueSuffix(String.valueOf(counter));
            } else {
                counter = 0;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
            methodsCounter.put(method.getName(), counter);
        }
        return new ViewInterfaceInfo(element, methods);
    }

    private void getMethods(TypeElement typeElement, TypeElement defaultStrategy, List<ViewMethod> rootMethods, List<ViewMethod> superinterfacesMethods) {
        for (Element element : typeElement.getEnclosedElements()) {
            AnnotationMirror annotation;
            TypeMirror strategyClassFromAnnotation;
            if (element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            if (methodElement.getReturnType().getKind() != TypeKind.VOID) {
                String message = String.format("You are trying generate ViewState for %s. But %s contains non-void method \"%s\" that return type is %s. See more here: https://github.com/Arello-Mobile/Moxy/issues/2", typeElement.getSimpleName(), typeElement.getSimpleName(), methodElement.getSimpleName(), methodElement.getReturnType());
                MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
            }
            TypeElement strategyClass = (strategyClassFromAnnotation = Util.getAnnotationValueAsTypeMirror(annotation = Util.getAnnotation(methodElement, STATE_STRATEGY_TYPE_ANNOTATION), "value")) != null ? (TypeElement)((DeclaredType)strategyClassFromAnnotation).asElement() : (defaultStrategy != null ? defaultStrategy : DEFAULT_STATE_STRATEGY);
            String tagFromAnnotation = Util.getAnnotationValueAsString(annotation, "tag");
            String methodTag = tagFromAnnotation != null ? tagFromAnnotation : methodElement.getSimpleName().toString();
            this.usedStrategies.add(strategyClass);
            ViewMethod method = new ViewMethod((DeclaredType)this.viewInterfaceElement.asType(), methodElement, strategyClass, methodTag);
            if (rootMethods.contains(method)) continue;
            if (superinterfacesMethods.contains(method)) {
                this.checkStrategyAndTagEquals(method, superinterfacesMethods.get(superinterfacesMethods.indexOf(method)));
                continue;
            }
            superinterfacesMethods.add(method);
        }
    }

    private void checkStrategyAndTagEquals(ViewMethod method, ViewMethod existingMethod) {
        ArrayList<String> differentParts = new ArrayList<String>();
        if (!existingMethod.getStrategy().equals(method.getStrategy())) {
            differentParts.add("strategies");
        }
        if (!existingMethod.getTag().equals(method.getTag())) {
            differentParts.add("tags");
        }
        if (!differentParts.isEmpty()) {
            String arguments = method.getParameterSpecs().stream().map(ParameterSpec::toString).collect(Collectors.joining(", "));
            String parts = differentParts.stream().collect(Collectors.joining(" and "));
            throw new IllegalStateException("Both " + existingMethod.getEnclosedClassName() + " and " + method.getEnclosedClassName() + " has method " + method.getName() + "(" + arguments + ") with different " + parts + ". Override this method in " + this.viewInterfaceName + " or make " + parts + " equals");
        }
    }

    private List<ViewMethod> iterateInterfaces(int level, TypeElement parentElement, TypeElement parentDefaultStrategy, List<ViewMethod> rootMethods, List<ViewMethod> superinterfacesMethods) {
        for (TypeMirror typeMirror : parentElement.getInterfaces()) {
            TypeElement anInterface = (TypeElement)((DeclaredType)typeMirror).asElement();
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            List<? extends TypeParameterElement> typeParameters = anInterface.getTypeParameters();
            if (typeArguments.size() > typeParameters.size()) {
                throw new IllegalArgumentException("Code generation for interface " + anInterface.getSimpleName() + " failed. Simplify your generics.");
            }
            TypeElement defaultStrategy = parentDefaultStrategy != null ? parentDefaultStrategy : this.getInterfaceStateStrategyType(anInterface);
            this.getMethods(anInterface, defaultStrategy, rootMethods, superinterfacesMethods);
            this.iterateInterfaces(level + 1, anInterface, defaultStrategy, rootMethods, superinterfacesMethods);
        }
        return superinterfacesMethods;
    }

    private TypeElement getInterfaceStateStrategyType(TypeElement typeElement) {
        AnnotationMirror annotation = Util.getAnnotation(typeElement, STATE_STRATEGY_TYPE_ANNOTATION);
        TypeMirror value = Util.getAnnotationValueAsTypeMirror(annotation, "value");
        if (value != null && value.getKind() == TypeKind.DECLARED) {
            return (TypeElement)((DeclaredType)value).asElement();
        }
        return null;
    }
}

