/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.viewstate;

import com.arellomobile.mvp.compiler.JavaFilesGenerator;
import com.arellomobile.mvp.compiler.MvpCompiler;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.compiler.viewstate.ViewInterfaceInfo;
import com.arellomobile.mvp.compiler.viewstate.ViewMethod;
import com.arellomobile.mvp.viewstate.MvpViewState;
import com.arellomobile.mvp.viewstate.ViewCommand;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

public final class ViewStateClassGenerator
extends JavaFilesGenerator<ViewInterfaceInfo> {
    @Override
    public List<JavaFile> generate(ViewInterfaceInfo viewInterfaceInfo) {
        ClassName viewName = viewInterfaceInfo.getName();
        TypeName nameWithTypeVariables = viewInterfaceInfo.getNameWithTypeVariables();
        DeclaredType viewInterfaceType = (DeclaredType)viewInterfaceInfo.getElement().asType();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)(viewName.simpleName() + "$$State")).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(MvpViewState.class), (TypeName[])new TypeName[]{nameWithTypeVariables})).addSuperinterface(nameWithTypeVariables).addTypeVariables(viewInterfaceInfo.getTypeVariables());
        for (ViewMethod method : viewInterfaceInfo.getMethods()) {
            TypeSpec commandClass = this.generateCommandClass(method, nameWithTypeVariables);
            classBuilder.addType(commandClass);
            classBuilder.addMethod(this.generateMethod(viewInterfaceType, method, nameWithTypeVariables, commandClass));
        }
        JavaFile javaFile = JavaFile.builder((String)viewName.packageName(), (TypeSpec)classBuilder.build()).indent("\t").build();
        return Collections.singletonList(javaFile);
    }

    private TypeSpec generateCommandClass(ViewMethod method, TypeName viewTypeName) {
        MethodSpec applyMethod = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(viewTypeName, "mvpView", new Modifier[0]).addExceptions(method.getExceptions()).addStatement("mvpView.$L($L)", new Object[]{method.getName(), method.getArgumentsString()}).build();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)method.getCommandClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariables(method.getTypeVariables()).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ViewCommand.class), (TypeName[])new TypeName[]{viewTypeName})).addMethod(this.generateCommandConstructor(method)).addMethod(applyMethod);
        for (ParameterSpec parameter : method.getParameterSpecs()) {
            classBuilder.addField(parameter.type, parameter.name, new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        return classBuilder.build();
    }

    private MethodSpec generateMethod(DeclaredType enclosingType, ViewMethod method, TypeName viewTypeName, TypeSpec commandClass) {
        String commandFieldName = Util.decapitalizeString(method.getCommandClassName());
        Random random = new Random();
        while (method.getArgumentsString().contains(commandFieldName)) {
            commandFieldName = commandFieldName + random.nextInt(10);
        }
        return MethodSpec.overriding((ExecutableElement)method.getElement(), (DeclaredType)enclosingType, (Types)MvpCompiler.getTypeUtils()).addStatement("$1N $2L = new $1N($3L)", new Object[]{commandClass, commandFieldName, method.getArgumentsString()}).addStatement("mViewCommands.beforeApply($L)", new Object[]{commandFieldName}).addCode("\n", new Object[0]).beginControlFlow("if (hasNotView())", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addCode("\n", new Object[0]).beginControlFlow("for ($T view : mViews)", new Object[]{viewTypeName}).addStatement("view.$L($L)", new Object[]{method.getName(), method.getArgumentsString()}).endControlFlow().addCode("\n", new Object[0]).addStatement("mViewCommands.afterApply($L)", new Object[]{commandFieldName}).build();
    }

    private MethodSpec generateCommandConstructor(ViewMethod method) {
        List<ParameterSpec> parameters = method.getParameterSpecs();
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameters(parameters).addStatement("super($S, $T.class)", new Object[]{method.getTag(), method.getStrategy()});
        if (parameters.size() > 0) {
            builder.addCode("\n", new Object[0]);
        }
        for (ParameterSpec parameter : parameters) {
            builder.addStatement("this.$1N = $1N", new Object[]{parameter});
        }
        return builder.build();
    }
}

