/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.client;

import java.util.HashMap;
import java.util.Map;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;
import tech.smartboot.mqtt.client.MqttClient;
import tech.smartboot.mqtt.client.processor.MqttAckProcessor;
import tech.smartboot.mqtt.client.processor.MqttProcessor;
import tech.smartboot.mqtt.client.processor.PubRelProcessor;
import tech.smartboot.mqtt.client.processor.PublishProcessor;
import tech.smartboot.mqtt.common.MqttMessageProcessor;
import tech.smartboot.mqtt.common.exception.MqttException;
import tech.smartboot.mqtt.common.message.MqttConnAckMessage;
import tech.smartboot.mqtt.common.message.MqttMessage;
import tech.smartboot.mqtt.common.message.MqttPingRespMessage;
import tech.smartboot.mqtt.common.message.MqttPubAckMessage;
import tech.smartboot.mqtt.common.message.MqttPubCompMessage;
import tech.smartboot.mqtt.common.message.MqttPubRecMessage;
import tech.smartboot.mqtt.common.message.MqttPubRelMessage;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.message.MqttSubAckMessage;

public class MqttClientProcessor
extends MqttMessageProcessor {
    private static final Map<Class<? extends MqttMessage>, MqttProcessor<? extends MqttMessage>> processors = new HashMap<Class<? extends MqttMessage>, MqttProcessor<? extends MqttMessage>>();

    public void process0(AioSession session, MqttMessage msg) {
        MqttClient client = (MqttClient)((Object)session.getAttachment());
        MqttProcessor<? extends MqttMessage> processor = processors.get(msg.getClass());
        if (processor == null) {
            throw new IllegalStateException("unsupported message type: " + msg.getClass().getSimpleName());
        }
        processor.process(client, (MqttMessage)msg);
    }

    public void stateEvent0(AioSession session, StateMachineEnum stateMachineEnum, Throwable throwable) {
        switch (stateMachineEnum) {
            case DECODE_EXCEPTION: {
                System.err.println("decodeException");
                throwable.printStackTrace();
                break;
            }
            case SESSION_CLOSED: {
                MqttClient client = (MqttClient)((Object)session.getAttachment());
                client.release();
                break;
            }
            case PROCESS_EXCEPTION: {
                if (!(throwable instanceof MqttException)) break;
                System.err.println("processException");
                throwable.printStackTrace();
                ((MqttException)throwable).getCallback().run();
                break;
            }
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    static {
        processors.put(MqttConnAckMessage.class, MqttClient::receiveConnAckMessage);
        processors.put(MqttPubAckMessage.class, new MqttAckProcessor());
        processors.put(MqttPublishMessage.class, new PublishProcessor());
        processors.put(MqttPubRecMessage.class, new MqttAckProcessor());
        processors.put(MqttPubCompMessage.class, new MqttAckProcessor());
        processors.put(MqttPubRelMessage.class, new PubRelProcessor());
        processors.put(MqttSubAckMessage.class, new MqttAckProcessor());
        processors.put(MqttPingRespMessage.class, (mqttClient, message) -> {
            mqttClient.pingTimeout = 0;
        });
    }
}

