/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.client;

import java.nio.channels.AsynchronousChannelGroup;
import java.util.Properties;
import java.util.function.Consumer;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import tech.smartboot.mqtt.client.TopicListener;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttConnAckMessage;
import tech.smartboot.mqtt.common.message.payload.WillMessage;
import tech.smartboot.mqtt.common.message.variable.properties.WillProperties;
import tech.smartboot.mqtt.common.util.MqttUtil;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public class Options {
    private String clientId;
    public static final int KEEP_ALIVE_INTERVAL_DEFAULT = 60;
    public static final int MAX_INFLIGHT_DEFAULT = 10;
    public static final boolean CLEAN_SESSION_DEFAULT = true;
    private int keepAliveInterval = 60;
    private int maxInflight = 10;
    private WillMessage willMessage;
    private String userName;
    private byte[] password;
    private SocketFactory socketFactory;
    private Properties sslClientProps = null;
    private boolean httpsHostnameVerificationEnabled = true;
    private HostnameVerifier sslHostnameVerifier = null;
    private boolean cleanSession = true;
    private int connectionTimeout = 5000;
    private int bufferSize = 4096;
    private int maxPacketSize = 0x100000;
    private int connectAckTimeout = 5;
    private MqttVersion mqttVersion = MqttVersion.MQTT_3_1_1;
    private boolean automaticReconnect = true;
    private int maxReconnectDelay = 5000;
    private String host;
    private int port;
    private AsynchronousChannelGroup group;
    private Consumer<MqttConnAckMessage> reconnectConsumer;
    private TopicListener topicListener = new TopicListener(){

        @Override
        public void subscribe(String topicFilter, MqttQoS mqttQoS) {
        }

        @Override
        public void unsubscribe(String topicFilter) {
        }
    };

    Options() {
    }

    public byte[] getPassword() {
        return this.password;
    }

    public Options setPassword(byte[] password) {
        this.password = password;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public Options setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(int maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public Options setKeepAliveInterval(int keepAliveInterval) throws IllegalArgumentException {
        if (keepAliveInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    public Options setMqttVersion(MqttVersion mqttVersion) {
        this.mqttVersion = mqttVersion;
        return this;
    }

    public int getMaxInflight() {
        return this.maxInflight;
    }

    public void setMaxInflight(int maxInflight) {
        if (maxInflight < 0) {
            throw new IllegalArgumentException();
        }
        this.maxInflight = maxInflight;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.connectionTimeout = connectionTimeout;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    WillMessage getWillMessage() {
        return this.willMessage;
    }

    public void setWillMessage(WillMessage willMessage) {
        if (willMessage == null) {
            this.willMessage = null;
            return;
        }
        ValidateUtils.notNull((Object)willMessage, (String)"willMessage can't be null");
        if (this.mqttVersion != MqttVersion.MQTT_5 && willMessage.getProperties() != null) {
            ValidateUtils.throwException((String)"will properties only support on mqtt5");
        } else if (this.mqttVersion == MqttVersion.MQTT_5 && willMessage.getProperties() == null) {
            willMessage.setProperties(new WillProperties());
        }
        this.willMessage = willMessage;
    }

    public Properties getSSLProperties() {
        return this.sslClientProps;
    }

    public void setSSLProperties(Properties props) {
        this.sslClientProps = props;
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.httpsHostnameVerificationEnabled;
    }

    public void setHttpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
        this.httpsHostnameVerificationEnabled = httpsHostnameVerificationEnabled;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.sslHostnameVerifier = hostnameVerifier;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public boolean isAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public Options setAutomaticReconnect(boolean automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public TopicListener getTopicListener() {
        return this.topicListener;
    }

    public void setTopicListener(TopicListener topicListener) {
        this.topicListener = topicListener;
    }

    public int getConnectAckTimeout() {
        return this.connectAckTimeout;
    }

    public void setConnectAckTimeout(int connectAckTimeout) {
        this.connectAckTimeout = connectAckTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public Options setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
        return this;
    }

    public AsynchronousChannelGroup group() {
        return this.group;
    }

    public Options setGroup(AsynchronousChannelGroup group) {
        this.group = group;
        return this;
    }

    Consumer<MqttConnAckMessage> reconnectConsumer() {
        return this.reconnectConsumer;
    }

    public Options setReconnectConsumer(Consumer<MqttConnAckMessage> reconnectConsumer) {
        this.reconnectConsumer = reconnectConsumer;
        return this;
    }

    String getClientId() {
        return this.clientId == null ? MqttUtil.createClientId() : this.clientId;
    }

    public Options setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }
}

