/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.client.processor;

import tech.smartboot.mqtt.client.MqttClient;
import tech.smartboot.mqtt.client.processor.MqttProcessor;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttMessage;
import tech.smartboot.mqtt.common.message.MqttPubAckMessage;
import tech.smartboot.mqtt.common.message.MqttPubRecMessage;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.message.variable.MqttPubQosVariableHeader;
import tech.smartboot.mqtt.common.message.variable.MqttPublishVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ReasonProperties;

public class PublishProcessor
implements MqttProcessor<MqttPublishMessage> {
    @Override
    public void process(MqttClient session, MqttPublishMessage mqttPublishMessage) {
        MqttQoS mqttQoS = mqttPublishMessage.getFixedHeader().getQosLevel();
        switch (mqttQoS) {
            case AT_MOST_ONCE: {
                session.accepted(mqttPublishMessage);
                break;
            }
            case AT_LEAST_ONCE: {
                this.processQos1(session, mqttPublishMessage);
                break;
            }
            case EXACTLY_ONCE: {
                this.processQos2(session, mqttPublishMessage);
                break;
            }
            default: {
                throw new IllegalStateException("unsupported qos level: " + mqttQoS);
            }
        }
    }

    private void processQos1(MqttClient mqttClient, MqttPublishMessage mqttPublishMessage) {
        mqttClient.accepted(mqttPublishMessage);
        ReasonProperties properties = null;
        if (mqttPublishMessage.getVersion() == MqttVersion.MQTT_5) {
            properties = new ReasonProperties();
        }
        MqttPubQosVariableHeader variableHeader = new MqttPubQosVariableHeader(((MqttPublishVariableHeader)mqttPublishMessage.getVariableHeader()).getPacketId(), properties);
        MqttPubAckMessage pubAckMessage = new MqttPubAckMessage(variableHeader);
        mqttClient.write((MqttMessage)pubAckMessage, false);
    }

    private void processQos2(MqttClient session, MqttPublishMessage mqttPublishMessage) {
        int messageId = ((MqttPublishVariableHeader)mqttPublishMessage.getVariableHeader()).getPacketId();
        ReasonProperties properties = null;
        if (mqttPublishMessage.getVersion() == MqttVersion.MQTT_5) {
            properties = new ReasonProperties();
        }
        MqttPubQosVariableHeader variableHeader = new MqttPubQosVariableHeader(messageId, properties);
        MqttPubRecMessage pubRecMessage = new MqttPubRecMessage(variableHeader);
        session.write(pubRecMessage, mqttPublishMessage);
    }
}

