/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import tech.smartboot.mqtt.common.TopicNode;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public class TopicToken {
    private TopicNode node;
    private final String topicFilter;
    private final TopicToken nextNode;

    public TopicToken(String node) {
        this(node, 0);
    }

    TopicToken(String topic, int offset) {
        int index = topic.indexOf(47, offset);
        if (index == -1) {
            this.node = this.updateNode(new TopicNode(offset, topic.length(), topic));
            ValidateUtils.isTrue(!this.node.contains('#') || this.node.length() == 1, "invalid topic filter");
            ValidateUtils.isTrue(!this.node.contains('+') || this.node.length() == 1, "invalid topic filter");
            this.nextNode = null;
        } else {
            this.node = this.updateNode(new TopicNode(offset, index, topic));
            ValidateUtils.isTrue(!this.node.contains('#'), "invalid topic filter");
            ValidateUtils.isTrue(!this.node.contains('+') || this.node.length() == 1, "invalid topic filter");
            this.nextNode = new TopicToken(topic, index + 1);
        }
        this.topicFilter = offset == 0 ? topic : null;
    }

    private TopicNode updateNode(TopicNode node) {
        if (node.equals(TopicNode.SHARE_NODE)) {
            return TopicNode.SHARE_NODE;
        }
        if (node.equals(TopicNode.WILDCARD_PLUS_NODE)) {
            return TopicNode.WILDCARD_PLUS_NODE;
        }
        if (node.equals(TopicNode.WILDCARD_HASH_NODE)) {
            return TopicNode.WILDCARD_HASH_NODE;
        }
        return node;
    }

    public TopicNode getNode() {
        return this.node;
    }

    public void setNode(TopicNode node) {
        this.node = node;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public TopicToken getNextNode() {
        return this.nextNode;
    }

    public boolean isWildcards() {
        if (this.node == TopicNode.WILDCARD_HASH_NODE || this.node == TopicNode.WILDCARD_PLUS_NODE) {
            return true;
        }
        return this.nextNode != null && this.nextNode.isWildcards();
    }

    public boolean isShared() {
        return this.node == TopicNode.SHARE_NODE;
    }
}

