/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.enums;

import tech.smartboot.mqtt.common.enums.MqttProtocolEnum;

public enum MqttVersion {
    MQTT_3_1(MqttProtocolEnum.MQIsdp, 3),
    MQTT_3_1_1(MqttProtocolEnum.MQTT, 4),
    MQTT_5(MqttProtocolEnum.MQTT, 5);

    private final MqttProtocolEnum protocol;
    private final byte level;

    private MqttVersion(MqttProtocolEnum protocolName, byte protocolLevel) {
        this.protocol = protocolName;
        this.level = protocolLevel;
    }

    public static MqttVersion getByProtocolWithVersion(MqttProtocolEnum protocolEnum, byte protocolLevel) {
        if (protocolEnum == MqttProtocolEnum.MQTT) {
            if (MqttVersion.MQTT_3_1_1.level == protocolLevel) {
                return MQTT_3_1_1;
            }
            if (MqttVersion.MQTT_5.level == protocolLevel) {
                return MQTT_5;
            }
        } else if (protocolEnum == MqttProtocolEnum.MQIsdp && protocolLevel == MQTT_3_1.protocolLevel()) {
            return MQTT_3_1;
        }
        return null;
    }

    public String protocolName() {
        return this.protocol.getName();
    }

    public byte protocolLevel() {
        return this.level;
    }
}

