/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.enums.MqttDisConnectReturnCode;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttVariableMessage;
import tech.smartboot.mqtt.common.message.variable.MqttDisconnectVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.DisConnectProperties;

public class MqttDisconnectMessage
extends MqttVariableMessage<MqttDisconnectVariableHeader> {
    public MqttDisconnectMessage(MqttDisconnectVariableHeader mqttConnAckVariableHeader) {
        super(MqttFixedHeader.DISCONNECT_HEADER);
        this.setVariableHeader(mqttConnAckVariableHeader);
    }

    @Override
    protected void decodeVariableHeader0(ByteBuffer buffer) {
        if (this.version == MqttVersion.MQTT_5) {
            byte returnCode = buffer.get();
            DisConnectProperties properties = new DisConnectProperties();
            properties.decode(buffer);
            this.setVariableHeader(new MqttDisconnectVariableHeader(MqttDisConnectReturnCode.valueOf(returnCode), properties));
        }
    }

    public MqttDisconnectMessage() {
        this(MqttDisconnectVariableHeader.MQTT3_DISCONNECT_VARIABLE_HEADER);
    }
}

