/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.socket.DecoderException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttVariableHeader;
import tech.smartboot.mqtt.common.message.payload.MqttPayload;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public abstract class MqttMessage {
    private static final MqttPayload NONE_PAYLOAD = new MqttPayload(){

        @Override
        protected int preEncode() {
            return 0;
        }

        @Override
        protected void writeTo(MqttWriter mqttWriter) {
        }
    };
    protected final MqttFixedHeader fixedHeader;
    protected MqttVersion version;
    private int remainingLength;

    public MqttMessage(MqttFixedHeader mqttFixedHeader) {
        this.fixedHeader = mqttFixedHeader;
    }

    public final MqttFixedHeader getFixedHeader() {
        return this.fixedHeader;
    }

    public abstract void decodeVariableHeader(ByteBuffer var1);

    public void decodePlayLoad(ByteBuffer buffer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(MqttWriter mqttWriter) throws IOException {
        ValidateUtils.isTrue(mqttWriter.writeSize() == 0, "invalid write size");
        try {
            MqttVariableHeader variableHeader = this.getVariableHeader();
            MqttPayload mqttPayload = this.getPayload();
            int remainingLength = variableHeader.preEncode() + mqttPayload.preEncode();
            this.fixedHeader.writeTo(mqttWriter);
            MqttCodecUtil.writeVariableLengthInt(mqttWriter, remainingLength);
            int size = mqttWriter.writeSize();
            variableHeader.writeTo(mqttWriter);
            mqttPayload.writeTo(mqttWriter);
            ValidateUtils.isTrue(mqttWriter.writeSize() - size == remainingLength, "encode error");
        }
        finally {
            mqttWriter.reset();
        }
    }

    public abstract MqttVariableHeader getVariableHeader();

    protected MqttPayload getPayload() {
        return NONE_PAYLOAD;
    }

    protected final int decodeMessageId(ByteBuffer buffer) {
        int messageId = MqttCodecUtil.decodeMsbLsb(buffer);
        if (messageId == 0) {
            throw new DecoderException("invalid messageId: " + messageId);
        }
        return messageId;
    }

    public int getRemainingLength() {
        return this.remainingLength;
    }

    public void setRemainingLength(int remainingLength) {
        this.remainingLength = remainingLength;
    }

    public final MqttVersion getVersion() {
        return this.version;
    }

    public final void setVersion(MqttVersion version) {
        this.version = version;
    }
}

