/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.util.ArrayList;
import java.util.List;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.message.MessageBuilder;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttSubscribeMessage;
import tech.smartboot.mqtt.common.message.MqttTopicSubscription;
import tech.smartboot.mqtt.common.message.MqttUnsubscribeMessage;
import tech.smartboot.mqtt.common.message.payload.MqttSubscribePayload;
import tech.smartboot.mqtt.common.message.payload.MqttUnsubscribePayload;
import tech.smartboot.mqtt.common.message.variable.MqttPubQosVariableHeader;
import tech.smartboot.mqtt.common.message.variable.MqttSubscribeVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ReasonProperties;
import tech.smartboot.mqtt.common.message.variable.properties.SubscribeProperties;

public final class MqttMessageBuilders {
    private MqttMessageBuilders() {
    }

    public static SubscribeBuilder subscribe() {
        return new SubscribeBuilder();
    }

    public static UnsubscribeBuilder unsubscribe() {
        return new UnsubscribeBuilder();
    }

    public static final class UnsubscribeBuilder
    implements MessageBuilder<MqttUnsubscribeMessage> {
        private List<String> topicFilters;
        private int packetId;
        private ReasonProperties properties;

        UnsubscribeBuilder() {
        }

        public UnsubscribeBuilder addTopicFilter(String topic) {
            if (this.topicFilters == null) {
                this.topicFilters = new ArrayList<String>(5);
            }
            this.topicFilters.add(topic);
            return this;
        }

        @Override
        public UnsubscribeBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        @Override
        public MqttQoS qos() {
            return MqttQoS.AT_LEAST_ONCE;
        }

        public void properties(ReasonProperties properties) {
            this.properties = properties;
        }

        @Override
        public MqttUnsubscribeMessage build() {
            MqttUnsubscribePayload mqttSubscribePayload = new MqttUnsubscribePayload(this.topicFilters);
            MqttPubQosVariableHeader variableHeader = new MqttPubQosVariableHeader(this.packetId, this.properties);
            return new MqttUnsubscribeMessage(MqttFixedHeader.UNSUBSCRIBE_HEADER, variableHeader, mqttSubscribePayload);
        }
    }

    public static final class SubscribeBuilder
    implements MessageBuilder<MqttSubscribeMessage> {
        private List<MqttTopicSubscription> subscriptions;
        private int packetId;
        private SubscribeProperties subscribeProperties;

        SubscribeBuilder() {
        }

        public SubscribeBuilder addSubscription(MqttQoS qos, String topic) {
            if (this.subscriptions == null) {
                this.subscriptions = new ArrayList<MqttTopicSubscription>(5);
            }
            MqttTopicSubscription subscription = new MqttTopicSubscription();
            subscription.setQualityOfService(qos);
            subscription.setTopicFilter(topic);
            this.subscriptions.add(subscription);
            return this;
        }

        @Override
        public SubscribeBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        @Override
        public MqttQoS qos() {
            return MqttQoS.AT_LEAST_ONCE;
        }

        public SubscribeBuilder subscribeProperties(SubscribeProperties subscribeProperties) {
            this.subscribeProperties = subscribeProperties;
            return this;
        }

        @Override
        public MqttSubscribeMessage build() {
            MqttSubscribePayload mqttSubscribePayload = new MqttSubscribePayload();
            mqttSubscribePayload.setTopicSubscriptions(this.subscriptions);
            MqttSubscribeVariableHeader variableHeader = new MqttSubscribeVariableHeader(this.packetId, this.subscribeProperties);
            return new MqttSubscribeMessage(MqttFixedHeader.SUBSCRIBE_HEADER, variableHeader, mqttSubscribePayload);
        }
    }
}

