/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttPacketIdentifierMessage;
import tech.smartboot.mqtt.common.message.payload.MqttUnsubscribePayload;
import tech.smartboot.mqtt.common.message.variable.MqttPubQosVariableHeader;
import tech.smartboot.mqtt.common.message.variable.MqttReasonVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ReasonProperties;

public class MqttUnsubscribeMessage
extends MqttPacketIdentifierMessage<MqttReasonVariableHeader> {
    private MqttUnsubscribePayload mqttUnsubscribePayload;

    public MqttUnsubscribeMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    @Override
    protected void decodeVariableHeader0(ByteBuffer buffer) {
        MqttPubQosVariableHeader header;
        int packetId = this.decodeMessageId(buffer);
        if (this.version == MqttVersion.MQTT_5) {
            ReasonProperties properties = new ReasonProperties();
            properties.decode(buffer);
            header = new MqttPubQosVariableHeader(packetId, properties);
        } else {
            header = new MqttPubQosVariableHeader(packetId, null);
        }
        this.setVariableHeader(header);
    }

    public MqttUnsubscribeMessage(MqttFixedHeader mqttFixedHeader, MqttReasonVariableHeader variableHeader, MqttUnsubscribePayload mqttUnsubscribePayload) {
        super(mqttFixedHeader, variableHeader);
        this.mqttUnsubscribePayload = mqttUnsubscribePayload;
    }

    @Override
    public void decodePlayLoad(ByteBuffer buffer) {
        ArrayList<String> unsubscribeTopics = new ArrayList<String>();
        int payloadLength = this.getRemainingLength() - this.getVariableHeaderLength();
        int limit = buffer.limit();
        buffer.limit(buffer.position() + payloadLength);
        while (buffer.hasRemaining()) {
            String decodedTopicName = MqttCodecUtil.decodeUTF8(buffer);
            unsubscribeTopics.add(decodedTopicName);
        }
        buffer.limit(limit);
        this.mqttUnsubscribePayload = new MqttUnsubscribePayload(unsubscribeTopics);
    }

    public MqttUnsubscribePayload getMqttUnsubscribePayload() {
        return this.mqttUnsubscribePayload;
    }
}

