/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.payload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.payload.MqttPayload;

public class MqttSubAckPayload
extends MqttPayload {
    private final List<Integer> grantedQoSLevels;

    public MqttSubAckPayload(int ... grantedQoSLevels) {
        if (grantedQoSLevels == null) {
            throw new NullPointerException("grantedQoSLevels");
        }
        ArrayList<Integer> list = new ArrayList<Integer>(grantedQoSLevels.length);
        for (int v : grantedQoSLevels) {
            list.add(v);
        }
        this.grantedQoSLevels = Collections.unmodifiableList(list);
    }

    public MqttSubAckPayload(Iterable<Integer> grantedQoSLevels) {
        if (grantedQoSLevels == null) {
            throw new NullPointerException("grantedQoSLevels");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer v : grantedQoSLevels) {
            if (v == null) break;
            list.add(v);
        }
        this.grantedQoSLevels = Collections.unmodifiableList(list);
    }

    public List<Integer> grantedQoSLevels() {
        return this.grantedQoSLevels;
    }

    @Override
    protected int preEncode() {
        return this.grantedQoSLevels.size();
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        for (int qos : this.grantedQoSLevels) {
            mqttWriter.writeByte((byte)qos);
        }
    }
}

