/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.payload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.MqttTopicSubscription;
import tech.smartboot.mqtt.common.message.payload.MqttPayload;

public final class MqttSubscribePayload
extends MqttPayload {
    private List<MqttTopicSubscription> topicSubscriptions;
    private List<byte[]> topics;

    public void setTopicSubscriptions(List<MqttTopicSubscription> topicSubscriptions) {
        this.topicSubscriptions = topicSubscriptions;
    }

    public List<MqttTopicSubscription> getTopicSubscriptions() {
        return this.topicSubscriptions;
    }

    @Override
    protected int preEncode() {
        int length = this.topicSubscriptions.size();
        this.topics = new ArrayList<byte[]>(this.topicSubscriptions.size());
        for (MqttTopicSubscription topicSubscription : this.topicSubscriptions) {
            byte[] bytes = MqttCodecUtil.encodeUTF8(topicSubscription.getTopicFilter());
            this.topics.add(bytes);
            length += bytes.length;
        }
        return length;
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        int i = 0;
        for (MqttTopicSubscription topicSubscription : this.topicSubscriptions) {
            mqttWriter.write(this.topics.get(i++));
            mqttWriter.writeByte((byte)topicSubscription.getQualityOfService().value());
        }
    }
}

