/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.payload;

import java.io.IOException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.message.Codec;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.variable.properties.WillProperties;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public class WillMessage
extends Codec {
    private String topic = null;
    private byte[] topicBytes;
    private byte[] payload;
    private MqttQoS willQos;
    private boolean retained;
    private WillProperties properties;

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    void check() {
        ValidateUtils.notBlank(this.topic, "topic is null");
        ValidateUtils.notNull((Object)this.willQos, "qos is null");
        ValidateUtils.notNull(this.payload, "payload is null");
    }

    public MqttQoS getWillQos() {
        return this.willQos;
    }

    public void setWillQos(MqttQoS willQos) {
        this.willQos = willQos;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public void setRetained(boolean retained) {
        this.retained = retained;
    }

    public WillProperties getProperties() {
        return this.properties;
    }

    public void setProperties(WillProperties properties) {
        this.properties = properties;
    }

    @Override
    protected int preEncode() {
        this.topicBytes = MqttCodecUtil.encodeUTF8(this.topic);
        int length = this.topicBytes.length + 2 + this.payload.length;
        if (this.properties != null) {
            length += this.properties.preEncode();
        }
        return length;
    }

    @Override
    protected void writeTo(MqttWriter writer) throws IOException {
        if (this.properties != null) {
            this.properties.writeTo(writer);
        }
        writer.write(this.topicBytes);
        MqttCodecUtil.writeMsbLsb(writer, this.payload.length);
        writer.write(this.payload);
    }
}

