/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.variable;

import java.io.IOException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.variable.MqttReasonVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ReasonProperties;

public class MqttPubQosVariableHeader
extends MqttReasonVariableHeader {
    private byte reasonCode;

    public MqttPubQosVariableHeader(int packetId, ReasonProperties properties) {
        super(packetId, properties);
    }

    public byte getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(byte reasonCode) {
        this.reasonCode = reasonCode;
    }

    @Override
    protected int preEncode0() {
        int length = 2;
        if (this.reasonCode != 0) {
            ++length;
        }
        return length;
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        MqttCodecUtil.writeMsbLsb(mqttWriter, this.getPacketId());
        if (this.reasonCode != 0) {
            mqttWriter.writeByte(this.reasonCode);
        }
        if (this.properties != null) {
            ((ReasonProperties)this.properties).writeTo(mqttWriter);
        }
    }
}

