/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.variable;

import java.io.IOException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.variable.MqttPacketIdVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.PublishProperties;

public class MqttPublishVariableHeader
extends MqttPacketIdVariableHeader<PublishProperties> {
    private final String topicName;
    private final byte[] encodedTopic;

    public MqttPublishVariableHeader(int packetId, String topicName, PublishProperties properties) {
        super(packetId, properties);
        this.topicName = topicName;
        this.encodedTopic = null;
    }

    public MqttPublishVariableHeader(int packetId, byte[] encodedTopic, PublishProperties properties) {
        super(packetId, properties);
        this.encodedTopic = encodedTopic;
        this.topicName = null;
    }

    public String getTopicName() {
        return this.topicName;
    }

    @Override
    protected int preEncode0() {
        int length = this.getPacketId() > 0 ? 2 : 0;
        return length += this.encodedTopic.length;
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        mqttWriter.write(this.encodedTopic);
        if (this.getPacketId() > 0) {
            MqttCodecUtil.writeMsbLsb(mqttWriter, this.getPacketId());
        }
        if (this.properties != null) {
            ((PublishProperties)this.properties).writeTo(mqttWriter);
        }
    }
}

